<?php

namespace App\Livewire\User;

use App\Models\Blog;
use App\Models\Category;
use App\Models\Product;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('components.user-layout')]
class BlogDetail extends Component
{
    use WithPagination;

    public $blog;
    public $recentBlogs;
    public $categories;
    public $blogSlug;

    public function mount($slug = null)
    {
        $this->blogSlug = $slug;
        $this->loadData();
    }

    public function loadData()
    {
         
        // Load all categories
        $this->categories = Category::orderBy('id', 'asc')->get();

        // Find the current blog
        if ($this->blogSlug) {
            $this->blog = Blog::where('slug', $this->blogSlug)->first();

            // If no blog is found, redirect to homepage
            if (!$this->blog) {
                return redirect()->route('index')->with('error', 'Blog not found');
            }
        } else {
            // If no slug provided, redirect to homepage
            return redirect()->route('index')->with('error', 'Blog not specified');
        }

        // Load other blogs (excluding current)
        $this->recentBlogs = Blog::where('slug', '!=', $this->blogSlug)
            ->orderBy('id', 'asc')
            ->get();
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        // Get blogs for the current blog with pagination
        $blog = Blog::where('slug', $this->blog->slug)->first();

        return view('livewire.user.blog-detail', [
            'blog' => $blog
        ]);
    }
}