<?php

namespace App\Livewire\User;

use App\Models\Blog;
use App\Models\Category;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('components.user-layout')]
class BlogPage extends Component
{
    public $blogs;
    public $recentBlogs;
    public $categories;

    public function mount()
    {
        $this->loadData();
    }

    public function loadData()
    {
        $this->blogs = Blog::select('blogs.id','blogs.name','blogs.slug','blogs.image')->Orderby('id','desc')->get();
        $this->recentBlogs = Blog::inRandomOrder()->orderby('id','desc')->get();
        $this->categories = Category::select('categories.id','categories.name','categories.slug','categories.image')->limit(10)->inRandomOrder()->get();
      
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        return view('livewire.user.blog-page');
    }
}
