<?php

namespace App\Livewire\User;

use App\Models\Blog;
use App\Models\Category;
use App\Models\SubCategory;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('components.user-layout')]
class BlogsByCategory extends Component
{
    public $blogs;
    public $recentBlogs;
    public $categories;
    public $subcategories;
    public $category;
    public $subcategory;
    public $categorySlug;
    public $subcategorySlug;
    public $blogsbysubcategories;

    public function mount($categoryslug = null, $subcategoryslug = null)
    {
        $this->categorySlug = $categoryslug;
        $this->subcategorySlug = $subcategoryslug;
        $this->loadData();
    }

    public function loadData()
    {
        $this->blogs = Blog::select('blogs.id','blogs.name','blogs.slug','blogs.image')->Orderby('id','desc')->get();
        $this->category = Category::select('id', 'name')->where('slug', $this->categorySlug)->first();
        $this->subcategory = SubCategory::select('id', 'name')->where('slug', $this->subcategorySlug)->first();
        $this->recentBlogs = Blog::limit(10)->orderby('id','desc')->get();
        $this->categories = Category::select('categories.id','categories.name','categories.slug','categories.image')->limit(10)->inRandomOrder()->get();
        $this->subcategories = SubCategory::select('sub_categories.id','sub_categories.name','sub_categories.slug','sub_categories.image')->limit(10)->where('category_id',$this->category->id)->get();
        $this->blogsbysubcategories = Blog::with(['category:id,name', 'subcategory:id,name'])
            ->where('blogs.subcategory_id', $this->subcategory->id)->orderby('id','desc')
            ->get();

           
      
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        return view('livewire.user.blogs-by-category');
    }
}
