<?php

namespace App\Livewire\User;

use App\Models\Brand;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('components.user-layout')]
class BrandPage extends Component
{
    public $brands;

    public function mount()
    {
        $this->loadData();
    }

    public function loadData()
    {
        
        $this->brands = Brand::orderBy('id', 'asc')
            ->get();
        
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        return view('livewire.user.brand-page');
    }
}
