<?php

namespace App\Livewire\User;

use App\Models\Category;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('components.user-layout')]
class CategoryPage extends Component
{
    public $categories;

    public function mount()
    {
        $this->loadData();
    }

    public function loadData()
    {
        
        $this->categories = Category::orderBy('id', 'asc')
            ->get();
        
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        return view('livewire.user.category-page');
    }
}
