<?php

namespace App\Livewire\User;

use App\Models\Blog;
use App\Models\Banner;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('components.user-layout')]
class Home extends Component
{
    public $blogs;
    public $recentBlogs;
    public $banners;
    public $brands;
    public $content;
    public $categories;
    public $products;
    public $testimonials;

    public function mount()
    {
        $this->loadData();
    }

    public function loadData()
    {
        $this->blogs = Blog::limit(8)->orderBy('id', 'asc')->get();
         $this->recentBlogs = Blog::inRandomOrder()->orderby('id','desc')->get();
        $this->banners = Banner::active()->orderBy('created_at', 'desc')->get();
        $this->brands = Brand::orderBy('name', 'asc')->get();
        $this->categories = Category::where('is_active', true)
            ->limit(8)
            ->orderBy('position', 'asc')
            ->orderBy('id', 'asc')
            ->get();
        $this->products = Product::limit(8)
            ->orderBy('created_at', 'desc')
            ->get();

        $this->testimonials = [
            [
                'name' => 'John M.',
                'designation' => 'Amazon Seller',
                'rating' => 5,
                'feedback' => 'Premier Products CO US has truly transformed my shopping experience. Their extensive selection of high-quality products and competitive pricing have allowed me to find exactly what I need without exceeding my budget. The customer service is outstanding, always available to help with any questions. Highly recommended!',
            ],
            [
                'name' => 'Sarah L.',
                'designation' => 'FBA Entrepreneur',
                'rating' => 4,
                'feedback' => 'I\'ve been shopping at Premier Products CO US for over a year now, and I couldn\'t be happier. The quality of the products is consistently top-notch, and the delivery is fast and reliable. Their customer service is exceptional, making my shopping experience smooth and hassle-free.',
            ],
            [
                'name' => 'Mike D.',
                'designation' => 'Online Retailer',
                'rating' => 5,
                'feedback' => 'Finding a trustworthy retailer was a challenge until I discovered Premier Products CO US. Their genuine product selection guarantees I\'m getting quality items, which is crucial for my shopping satisfaction. The simplicity of their ordering process and the efficiency of their delivery have saved me so much time.',
            ],
            [
                'name' => 'Laura K.',
                'designation' => 'Small Business Owner',
                'rating' => 5,
                'feedback' => 'Premier Products CO US has been instrumental in enhancing my shopping experience. Their dedication to offering high-quality products and exceptional customer service is something I truly value. The personalized support I receive makes me feel appreciated as a customer, and I always know I\'m getting the best.',
            ],
            [
                'name' => 'Alex T.',
                'designation' => 'E-commerce Specialist',
                'rating' => 4,
                'feedback' => 'Shopping at premier Products CO US has been a fantastic experience. The team\'s dedication to offering high-quality products and exceptional customer service is clear in everything they do. From product selection to delivery, they manage every detail with professionalism and efficiency. I feel confident in the products I purchase, knowing they\'ve been carefully chosen for quality.',
            ],
            [
                'name' => 'Emily R.',
                'designation' => 'Amazon FBA Seller',
                'rating' => 5,
                'feedback' => 'Premier Products CO US stands out for its exceptional customer service. Whenever I\'ve had questions or needed assistance, their team has been quick to respond and incredibly helpful. Their reliable delivery and quality assurance give me peace of mind, knowing I\'m getting top-notch products and an outstanding shopping experience.',
            ],
            [
                'name' => 'David S.',
                'designation' => 'Online Business Owner',
                'rating' => 5,
                'feedback' => 'I\'ve shopped with several retailers, but none compare to Premier Products CO US. Their platform is user-friendly, making it easy to find and purchase the products I need. The fast delivery from their USA-based distribution center is a major advantage, ensuring I get what I want quickly and making my shopping experience completely hassle-free.',
            ],
        ];
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        return view('livewire.user.home');
    }
}