<?php

namespace App\Livewire\User;

use App\Models\Category;
use App\Models\Page;
use App\Models\Product;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('components.user-layout')]
class Policies extends Component
{
    use WithPagination;

    public $policies;
    public $policy;
    public $policySlug;

    public function mount($slug = null)
    {
        $this->policySlug = $slug;
        $this->loadData();
    }

    public function loadData()
    {
        // Load all policies
        $this->policies = Page::orderBy('id', 'asc')->get();

        // Find the current policy
        if ($this->policySlug) {
            $this->policy = Page::where('slug', $this->policySlug)->first();

            // If no policy is found, redirect to homepage
            if (!$this->policy) {
                return redirect()->route('index')->with('error', 'Policy not found');
            }
        } else {
            // If no slug provided, redirect to homepage
            return redirect()->route('index')->with('error', 'Policy not specified');
        }

        // Load other policies (excluding current)
        $this->policies = Page::where('slug', '!=', $this->policySlug)
            ->orderBy('id', 'asc')
            ->get();
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        // Get products for the current category with pagination
        $policy = Page::where('slug', $this->policy->slug)->first();
           

        return view('livewire.user.policies', [
            'policy' => $policy
        ]);
    }
}