<?php

namespace App\Livewire\User;

use App\Models\Category;
use App\Models\Product;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('components.user-layout')]
class ProductDetail extends Component
{
    use WithPagination;

    public $categories;
    public $products;
    public $product;
    public $productSlug;

    public function mount($slug = null)
    {
        $this->productSlug = $slug;
        $this->loadData();
    }

    public function loadData()
    {
        // Load all products
        $this->products = Product::orderBy('id', 'asc')->get();

        // Find the current product
        if ($this->productSlug) {
            $this->product = Product::where('slug', $this->productSlug)->first();

            // If no product is found, redirect to homepage
            if (!$this->product) {
                return redirect()->route('index')->with('error', 'Product not found');
            }
        } else {
            // If no slug provided, redirect to homepage
            return redirect()->route('index')->with('error', 'Product not specified');
        }

        // Load other products (excluding current)
        $this->products = Product::where('slug', '!=', $this->productSlug)
            ->orderBy('id', 'asc')
            ->get();
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        // Get products for the current product with pagination
        $product = Product::find($this->product->id);

        return view('livewire.user.product-detail', [
            'product' => $product
        ]);
    }
}