<?php

namespace App\Livewire\User;

use App\Models\Product;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('components.user-layout')]
class ProductPage extends Component
{
    public $products;

    public function mount()
    {
        $this->loadData();
    }

    public function loadData()
    {

        $this->products = Product::orderBy('id', 'asc')
            ->get();
        
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        return view('livewire.user.product-page');
    }
}
