<?php

namespace App\Http\Livewire\User;

use Livewire\Component;
use App\Models\Blog;
use Illuminate\Support\Str;
use Livewire\Attributes\Layout;


class Search extends Component
{
    public $query = '';
    public $searchResults = [];
    public $showResults = false;

    protected $queryString = [
        'query' => ['except' => '']
    ];

    public function updatedQuery()
    {
        if (strlen($this->query) > 2) {
            $this->searchResults = Blog::with(['category', 'subCategory'])
                ->where(function($q) {
                    $q->where('title', 'like', '%' . $this->query . '%')
                      ->orWhere('content', 'like', '%' . $this->query . '%')
                      ->orWhere('excerpt', 'like', '%' . $this->query . '%');
                })
                ->take(8)
                ->get()
                ->toArray();
            
            $this->showResults = true;
        } else {
            $this->searchResults = [];
            $this->showResults = false;
        }
    }

    public function selectResult($blogId)
    {
        $blog = Blog::find($blogId);
        if ($blog) {
            return redirect()->route('user.blog.search', [
                'categoryslug' => $blog->category->slug,
                'subcategoryslug' => $blog->subCategory->slug,
                'slug' => $blog->slug
            ]);
        }
    }

    public function clearSearch()
    {
        $this->query = '';
        $this->searchResults = [];
        $this->showResults = false;
    }

    public function render()
    {
        return view('livewire.user.search');
    }
}