<?php

namespace App\Livewire\User;

use App\Models\Category;
use App\Models\Product;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('components.user-layout')]
class Services extends Component
{
   
    public $categories;
    public $products;
    
    public function mount()
    {
        $this->loadData();
    }

    public function loadData()
    {
        
        $this->categories = Category::where('is_active', true)
            ->limit(8)
            ->orderBy('position', 'asc')
            ->orderBy('id', 'asc')
            ->get();
        $this->products = Product::limit(8)
            ->orderBy('created_at', 'desc')
            ->get();

        
    }

    public function refreshData()
    {
        $this->loadData();
        $this->dispatch('data-refreshed');
    }

    public function render()
    {
        return view('livewire.user.services');
    }
}
