<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_metas', function (Blueprint $table) {
            $table->id();
             // Home Page SEO
            $table->string('home_meta_title')->nullable();
            $table->text('home_meta_description')->nullable();
            $table->text('home_meta_keywords')->nullable();
            $table->text('home_meta_tags')->nullable();
            $table->string('home_title')->nullable();
            $table->text('home_page_schema')->nullable();
            
            // About Page SEO
            $table->string('about_meta_title')->nullable();
            $table->text('about_meta_description')->nullable();
            $table->text('about_meta_keywords')->nullable();
            $table->text('about_meta_tags')->nullable();
            $table->string('about_title')->nullable();
            $table->text('about_page_schema')->nullable();
            
            // Contact Page SEO
            $table->string('contact_meta_title')->nullable();
            $table->text('contact_meta_description')->nullable();
            $table->text('contact_meta_keywords')->nullable();
            $table->text('contact_meta_tags')->nullable();
            $table->string('contact_title')->nullable();
            $table->text('contact_page_schema')->nullable();
            
            // Service Page SEO
            $table->string('service_meta_title')->nullable();
            $table->text('service_meta_description')->nullable();
            $table->text('service_meta_keywords')->nullable();
            $table->text('service_meta_tags')->nullable();
            $table->string('service_title')->nullable();
            $table->text('service_page_schema')->nullable();
            
            // Products Page SEO
            $table->string('products_meta_title')->nullable();
            $table->text('products_meta_description')->nullable();
            $table->text('products_meta_keywords')->nullable();
            $table->text('products_meta_tags')->nullable();
            $table->text('product_page_schema')->nullable();
            
            // FAQ Page SEO
            $table->string('faq_meta_title')->nullable();
            $table->text('faq_meta_description')->nullable();
            $table->text('faq_meta_keywords')->nullable();
            $table->text('faq_meta_tags')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_metas');
    }
};
