<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();
            $table->string('firstname');
            $table->string('lastname');
            $table->string('companyname')->nullable();
            $table->text('address_primary')->nullable();
            $table->text('address_secondary')->nullable();
            $table->string('country')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('employeeid')->nullable();
            $table->string('seller_permit')->nullable();
            $table->string('duration')->nullable();
            $table->string('location')->nullable();
            $table->string('period')->nullable();
            $table->text('reference')->nullable();
            $table->string('permit_doc')->nullable();
            $table->integer('mail_count')->default(0);
            $table->string('source')->default('website');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
