<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class PermissionSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions
        $permissions = [
            // User Management
            'users.view',
            'users.create', 
            'users.edit',
            'users.delete',
            
            // Role Management
            'roles.view',
            'roles.create',
            'roles.edit', 
            'roles.delete',
            
            // Blog Management
            'blogs.view',
            'blogs.create',
            'blogs.edit',
            'blogs.delete',
            
            // Category Management
            'categories.view',
            'categories.create',
            'categories.edit',
            'categories.delete',
            
            // Product Management
            'products.view',
            'products.create',
            'products.edit',
            'products.delete',
            
            // Page Management
            'pages.view',
            'pages.create',
            'pages.edit',
            'pages.delete',
            
            // SEO Management
            'seo.view',
            'seo.edit',
            
            // Dashboard
            'dashboard.view',
            
            // Settings
            'settings.manage',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create roles
        $superAdmin = Role::firstOrCreate(['name' => 'Super Admin']);
        $superAdmin->syncPermissions(Permission::all());

        $admin = Role::firstOrCreate(['name' => 'Admin']);
        $admin->syncPermissions(array_filter($permissions, function($perm) {
            return !in_array($perm, ['users.delete', 'roles.delete']);
        }));

        $contentManager = Role::firstOrCreate(['name' => 'Content Manager']);
        $contentManager->syncPermissions([
            'dashboard.view',
            'blogs.view', 'blogs.create', 'blogs.edit', 'blogs.delete',
            'categories.view', 'categories.create', 'categories.edit', 'categories.delete',
            'pages.view', 'pages.create', 'pages.edit', 'pages.delete',
            'seo.view', 'seo.edit',
        ]);

        $productManager = Role::firstOrCreate(['name' => 'Product Manager']);
        $productManager->syncPermissions([
            'dashboard.view',
            'products.view', 'products.create', 'products.edit', 'products.delete',
            'categories.view', 'categories.create', 'categories.edit',
        ]);

        // Assign super admin to first user
        $user = User::first();
        if ($user && !$user->hasRole('Super Admin')) {
            $user->assignRole('Super Admin');
        }
    }
}