{{-- resources/views/components/admin-nav-item.blade.php --}}
@props(['href', 'icon', 'label', 'active' => false])

@php
    $isActive = request()->url() === $href || request()->is(trim($href, '/') . '/*');
@endphp

<a href="{{ $href }}" 
   wire:navigate=""
   {{ $attributes->merge(['class' => 'flex items-center px-4 py-3 text-sm font-medium rounded-lg transition-colors duration-200 ' . ($isActive ? 'bg-orange-500 text-white border-r-2 border-orange-500' : 'text-white hover:bg-gray-50 hover:text-gray-900')]) }}>
    <i class="fas fa-{{ $icon }} mr-3 w-5 text-center"></i>
    {{ $label }}
    
    @if($isActive)
        <span class="ml-auto w-2 h-2 bg-orange-500 rounded-full"></span>
    @endif
</a>