@php
$settings = \App\Models\Setting::find(1);
@endphp
<footer class="bg-gradient-to-br from-gray-900 to-gray-800 text-white pt-16 pb-8 relative overflow-hidden">
  <!-- Background Elements -->
  <div class="absolute inset-0 opacity-5">
    <div class="absolute top-0 left-0 w-72 h-72 bg-yellow-400 rounded-full blur-3xl"></div>
    <div class="absolute bottom-0 right-0 w-96 h-96 bg-indigo-600 rounded-full blur-3xl"></div>
  </div>

  <div class="max-w-7xl mx-auto px-6 sm:px-8 lg:px-10 relative z-10">
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-12">
      <!-- Company Info -->
      <div class="animate-fadeInUp">
        <div class="flex items-center mb-6">
          <div class="w-2 h-8 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-3"></div>
          <a href="{{route('user.home')}}" wire:navigate class="flex items-center space-x-2">
        <img src="@if($settings){{asset('storage/' .$settings->footer_logo)}}@endif" alt="Logo" class="h-8">
      </a>
          
        </div>
        <p class="text-gray-300 mb-6 leading-relaxed">
          Your trusted source for bulk and wholesale Amazon products at unbeatable prices with premium service and support.
        </p>
        <div class="flex space-x-4">
          <a href="#" class="w-10 h-10 bg-gray-700 hover:bg-yellow-500 rounded-lg flex items-center justify-center transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg" aria-label="Visit our Facebook page">
            <i class="fab fa-facebook-f text-white"></i>
          </a>
          <a href="#" class="w-10 h-10 bg-gray-700 hover:bg-yellow-500 rounded-lg flex items-center justify-center transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg" aria-label="Visit our Instagram page">
            <i class="fab fa-instagram text-white"></i>
          </a>
          <a href="#" class="w-10 h-10 bg-gray-700 hover:bg-yellow-500 rounded-lg flex items-center justify-center transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg" aria-label="Visit our Linkedin page">
            <i class="fab fa-linkedin-in text-white"></i>
          </a>
          <a href="#" class="w-10 h-10 bg-gray-700 hover:bg-yellow-500 rounded-lg flex items-center justify-center transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg" aria-label="Visit our Twitter page">
            <i class="fab fa-twitter text-white"></i>
          </a>
        </div>
      </div>

      <!-- Quick Links -->
      <div class="animate-fadeInUp" style="animation-delay: 0.1s;">
        <h3 class="text-xl font-bold mb-6 flex items-center">
          <i class="fas fa-link text-yellow-400 mr-3"></i>
          Quick Links
        </h3>
        <ul class="space-y-3">
          <li>
            <a href="{{route('user.home')}}" wire:navigate class="text-gray-300 hover:text-yellow-400 transition-all duration-300 flex items-center group">
              <i class="fas fa-chevron-right text-yellow-400 text-xs mr-2 opacity-0 group-hover:opacity-100 transition-opacity"></i>
              Home
            </a>
          </li>
          <li>
            <a href="{{route('user.about')}}" wire:navigate class="text-gray-300 hover:text-yellow-400 transition-all duration-300 flex items-center group">
              <i class="fas fa-chevron-right text-yellow-400 text-xs mr-2 opacity-0 group-hover:opacity-100 transition-opacity"></i>
              About Us
            </a>
          </li>
          <li>
            <a href="{{route('user.products')}}" wire:navigate class="text-gray-300 hover:text-yellow-400 transition-all duration-300 flex items-center group">
              <i class="fas fa-chevron-right text-yellow-400 text-xs mr-2 opacity-0 group-hover:opacity-100 transition-opacity"></i>
              Products
            </a>
          </li>
          <li>
            <a href="{{route('user.contact')}}" wire:navigate class="text-gray-300 hover:text-yellow-400 transition-all duration-300 flex items-center group">
              <i class="fas fa-chevron-right text-yellow-400 text-xs mr-2 opacity-0 group-hover:opacity-100 transition-opacity"></i>
              Contact
            </a>
          </li>
        </ul>
      </div>

      <!-- Categories -->
      <div class="animate-fadeInUp" style="animation-delay: 0.2s;">
        <h3 class="text-xl font-bold mb-6 flex items-center">
          <i class="fas fa-tags text-yellow-400 mr-3"></i>
          Top Categories
        </h3>
        <ul class="space-y-3">
            @php
                $footerCategories = \App\Models\Category::all();
            @endphp
            @foreach($footerCategories as $category)
          <li>
            <a href="{{route('user.products.by-category',$category->slug)}}" wire:navigate class="text-gray-300 hover:text-yellow-400 transition-all duration-300 flex items-center group">
              <i class="fas fa-chevron-right text-yellow-400 text-xs mr-2 opacity-0 group-hover:opacity-100 transition-opacity"></i>
              {{$category->name}}
            </a>
          </li>
            @endforeach
        </ul>
      </div>

      <!-- Newsletter -->
      <div class="animate-fadeInUp" style="animation-delay: 0.3s;">
        <h3 class="text-xl font-bold mb-6 flex items-center">
          <i class="fas fa-envelope text-yellow-400 mr-3"></i>
          Stay Updated
        </h3>
        <p class="text-gray-300 mb-4">Subscribe to get updates on new wholesale deals and exclusive offers.</p>
        <form id="newsletter-form" class="space-y-4">
          <div class="relative">
            <input type="email" id="newsletter-email"
              class="w-full px-4 py-3 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:border-transparent text-white placeholder-gray-400 transition-all duration-300"
              placeholder="Enter your email" required>
            <i class="fas fa-envelope absolute right-3 top-3 text-gray-400"></i>
          </div>
          <button type="submit"
            class="w-full bg-gradient-to-r from-yellow-500 to-yellow-600 hover:from-yellow-600 hover:to-yellow-700 text-white font-semibold py-3 px-6 rounded-lg transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg flex items-center justify-center">
            <span>Subscribe Now</span>
            <i class="fas fa-paper-plane ml-2"></i>
          </button>
        </form>
      </div>
    </div>

    <!-- Divider -->
    <div class="border-t border-gray-700 pt-8 mb-6">
      <div class="flex flex-col lg:flex-row items-center justify-between space-y-4 lg:space-y-0">
        <!-- Copyright -->
        <div class="text-gray-200 text-sm">
          <p>&copy; <span id="year"></span> WholesaleHub. All rights reserved.</p>
        </div>
        
        <!-- Additional Links -->
        <div class="flex flex-wrap justify-center space-x-6 text-sm">
            @php
                $footerPages = \App\Models\Page::all();
            @endphp
            @foreach($footerPages as $page)
          <a href="{{route('user.policies',$page->slug)}}" wire:navigate class="text-gray-200 hover:text-yellow-400 transition-colors">{{ $page->title }}</a>
            @endforeach
         
        </div>
        
        
      </div>
    </div>

    <!-- Trust Badges -->
    <div class="flex flex-wrap items-center justify-center gap-6 pt-6 border-t border-gray-700">
      <div class="flex items-center space-x-2 text-gray-200">
        <i class="fas fa-shield-alt text-green-400"></i>
        <span class="text-sm">Secure Payments</span>
      </div>
      <div class="flex items-center space-x-2 text-gray-200">
        <i class="fas fa-truck text-blue-400"></i>
        <span class="text-sm">Fast Shipping</span>
      </div>
      <div class="flex items-center space-x-2 text-gray-200">
        <i class="fas fa-headset text-purple-400"></i>
        <span class="text-sm">24/7 Support</span>
      </div>
    </div>
  </div>

  <style>
    @keyframes fadeInUp {
      0% { opacity: 0; transform: translateY(20px); }
      100% { opacity: 1; transform: translateY(0); }
    }
    .animate-fadeInUp { animation: fadeInUp 0.8s ease-out forwards; opacity: 0; }
  </style>

  <script>
    // Set current year
    document.getElementById('year').textContent = new Date().getFullYear();
  </script>
</footer>