@php
$settings = \App\Models\Setting::find(1);
@endphp
<!-- ================= HEADER START ================= -->
<header class="backdrop-blur-lg bg-white/70 shadow-md fixed top-0 left-0 right-0 z-50 transition-all duration-300">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center h-16">

      <!-- Logo -->
      <a href="{{route('user.home')}}" wire:navigate class="flex items-center space-x-2">
        
        <picture>
  <source srcset="@if($settings){{asset('storage/' .$settings->main_logo)}}@endif" type="image/webp">
  <img src="@if($settings){{asset('storage/' .$settings->main_logo)}}@endif" alt="DreamzPlanet Logo" class="h-8" fetchpriority="high"
  decoding="async">
</picture>

      </a>

      <!-- Desktop Navigation -->
      <nav class="hidden md:flex items-center space-x-8 font-medium relative">
        <a href="{{route('user.home')}}" wire:navigate class="text-gray-700 hover:text-indigo-600 transition">Home</a>

        
        <div class="relative group">
          <button id="servicesBtn" class="text-gray-700 hover:text-indigo-600 transition flex items-center space-x-1 focus:outline-none">
            Products
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
          </button>
          <!-- dropdown -->
          <div class="absolute left-0 mt-2 w-64 bg-white  rounded-md shadow-lg  ring-opacity-5 opacity-0 invisible group-hover:visible group-hover:opacity-100 transition-all origin-top">
            <div class="p-4">
                @php
                    $headerCategories = \App\Models\Category::all();
                @endphp
                @foreach($headerCategories as $category)
              <a href="{{route('user.products.by-category',$category->slug)}}" wire:navigate="" class="block p-2 rounded hover:text-indigo-600 transition">{{$category->name}}</a>
              @endforeach
            </div>
          </div>
        </div>
        <a href="{{route('user.about')}}" wire:navigate class="text-gray-700 hover:text-indigo-600 transition">About</a>
        <a href="{{route('user.services')}}" wire:navigate class="text-gray-700 hover:text-indigo-600 transition">Services</a>
        <a href="{{route('user.contact')}}" wire:navigate class="text-gray-700 hover:text-indigo-600 transition">Contact</a>
        <a href="{{route('user.blogs')}}" wire:navigate class="text-gray-700 hover:text-indigo-600 transition">Blogs</a>
      </nav>

      <!-- Search + Mobile Button -->
      <div class="flex items-center space-x-4">
        <!-- Desktop Button -->
        <div class="hidden md:flex items-center px-3 py-1 rounded-full">
          <a href="{{route('user.apply-wholesale')}}" wire:navigate id="scrollBtn"
            class="inline-block bg-yellow-500 hover:bg-yellow-400 text-black font-semibold py-3 px-8 rounded-full shadow-lg transition-all duration-300 animate-fadeInUp"
            style="animation-delay: 0.6s;">
            Get Wholesale Access
          </a>
        </div>

        <!-- Mobile Menu Button -->
        <button id="menu-btn" class="md:hidden text-gray-700 hover:text-indigo-600 focus:outline-none" aria-label="Menu Button">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
              d="M4 6h16M4 12h16m-7 6h7" />
          </svg>
        </button>
      </div>
    </div>
  </div>
</header>

<!-- ================= MOBILE DRAWER ================= -->
<div id="drawer-overlay" class="hidden fixed inset-0 bg-black/40 backdrop-blur-sm z-40"></div>

<div id="mobile-drawer"
  class="fixed top-0 left-0 h-full w-72 backdrop-blur-lg bg-white/70 shadow-2xl z-50 transform -translate-x-full transition-transform duration-300">
  <div class="p-5 flex justify-between items-center border-b">
    <h2 class="text-lg font-semibold text-indigo-700">Menu</h2>
    <button id="drawer-close" class="text-gray-600 hover:text-indigo-600" aria-label="Close menu">
      <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none"
        viewBox="0 0 24 24" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
          d="M6 18L18 6M6 6l12 12" />
      </svg>
    </button>
  </div>

  <!-- Mobile Nav -->
  <nav class="flex flex-col p-5 space-y-4 text-gray-700 font-medium">
    <a href="{{route('user.home')}}" wire:navigate class="hover:text-indigo-600 transition">Home</a>

    <!-- Products Dropdown (Mobile) -->
    <div>
      <button id="mobile-products-btn" class="flex justify-between items-center w-full hover:text-indigo-600">
        <span>Products</span>
        <svg id="mobile-products-icon" xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none"
          viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
            d="M19 9l-7 7-7-7" />
        </svg>
      </button>
      <div id="mobile-products-menu" class="hidden pl-4 mt-2 space-y-2 text-sm">
        @foreach($headerCategories as $category)
        <a href="{{route('user.products.by-category',$category->slug)}}" wire:navigate class="block text-gray-700 hover:text-indigo-600">{{$category->name}}</a>
        @endforeach
      </div>
    </div>

    <a href="{{route('user.about')}}" wire:navigate class="hover:text-indigo-600 transition">About Us</a>
    <a href="{{route('user.services')}}" wire:navigate class="hover:text-indigo-600 transition">Services</a>
    <a href="{{route('user.blogs')}}" wire:navigate class="hover:text-indigo-600 transition">Blogs</a>
    <a href="{{route('user.contact')}}" wire:navigate class="hover:text-indigo-600 transition">Contact</a>
    <a href="{{route('user.apply-wholesale')}}" wire:navigate class="inline-block bg-yellow-500 hover:bg-yellow-400 text-black font-semibold py-3 px-8 rounded-full shadow-lg transition-all duration-300">
      Get Wholesale Access
    </a>
  </nav>
</div>
<!-- ================= HEADER END ================= -->

