<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>New Wholesale Application</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #f8f9fa; padding: 20px; text-align: center; border-radius: 5px; }
        .content { background: white; padding: 20px; border-radius: 5px; margin-top: 20px; }
        .field { margin-bottom: 10px; }
        .field-label { font-weight: bold; color: #555; }
        .footer { margin-top: 20px; padding: 20px; background: #f8f9fa; text-align: center; border-radius: 5px; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Wholesale Application</h1>
            <p>You have received a new wholesale application from your website.</p>
        </div>
        
        <div class="content">
            <h2>Applicant Information</h2>
            
            <div class="field">
                <span class="field-label">Name:</span>
                {{ $lead->firstname }} {{ $lead->lastname }}
            </div>
            
            <div class="field">
                <span class="field-label">Company:</span>
                {{ $lead->companyname ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">Email:</span>
                {{ $lead->email ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">Phone:</span>
                {{ $lead->phone ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">Address:</span>
                {{ $lead->address_primary ?? 'N/A' }}
                @if($lead->address_secondary)
                    , {{ $lead->address_secondary }}
                @endif
            </div>
            
            <div class="field">
                <span class="field-label">Location:</span>
                {{ $lead->city ?? 'N/A' }}, {{ $lead->state ?? 'N/A' }}, {{ $lead->country ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">Seller Permit:</span>
                {{ $lead->seller_permit ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">Business Duration:</span>
                {{ $lead->period ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">Sales Location:</span>
                {{ $lead->location ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">How they heard about us:</span>
                {{ $lead->reference ?? 'N/A' }}
            </div>
            
            <div class="field">
                <span class="field-label">Source:</span>
                {{ $lead->source ?? 'Website' }}
            </div>
            
            <div class="field">
                <span class="field-label">Submitted:</span>
                {{ $lead->created_at->format('F j, Y \a\t g:i A') }}
            </div>
            
            @if($lead->permit_doc)
            <div class="field">
                <span class="field-label">Permit Document:</span>
                <a href="{{ asset('storage/' . $lead->permit_doc) }}" target="_blank">View Document</a>
            </div>
            @endif
        </div>
        
        <div class="footer">
            <p>This email was sent automatically from your website. Please do not reply to this email.</p>
            <p>&copy; {{ date('Y') }} {{ config('app.name', 'Your Company') }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>