{{-- resources/views/livewire/admin/banners.blade.php --}}
<div>
    <!-- Header Section -->
    <div class="bg-white rounded-lg border border-gray-200 p-6 mb-6">
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Banners Management</h1>
                <p class="text-gray-600 mt-1">Manage website banners and promotional content</p>
            </div>
            <button 
                wire:click="create"
                wire:loading.attr="disabled"
                class="px-4 py-2 bg-orange-500 text-white rounded-md hover:bg-orange-600 transition-colors flex items-center space-x-2 text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed"
            >
                <span wire:loading.remove wire:target="create">
                    <i class="fas fa-plus"></i>
                    <span>Add Banner</span>
                </span>
                <span wire:loading wire:target="create" class="flex items-center space-x-2">
                    <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-white"></div>
                    <span>Opening...</span>
                </span>
            </button>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="bg-white rounded-lg border border-gray-200 p-6 mb-6">
        <div class="flex flex-col md:flex-row gap-4">
            <!-- Search -->
            <div class="flex-1">
                <div class="relative">
                    <div class="flex items-center bg-gray-100 rounded-lg px-3 py-2 w-full">
                        <i class="fas fa-search text-gray-400 mr-2"></i>
                        <input 
                            type="text" 
                            wire:model.live="search"
                            placeholder="Search banners by title, subtitle, or URL..." 
                            class="bg-transparent border-none focus:outline-none focus:ring-0 w-full text-sm"
                        >
                    </div>
                </div>
            </div>

            <!-- Filters -->
            <div class="flex gap-4">
                <select wire:model.live="typeFilter" class="bg-gray-100 border-none rounded-lg px-3 py-2 text-sm focus:ring-0">
                    <option value="">All Types</option>
                    <option value="home">Home</option>
                    <option value="category">Category</option>
                    <option value="product">Product</option>
                    <option value="promotional">Promotional</option>
                    <option value="sidebar">Sidebar</option>
                    <option value="footer">Footer</option>
                </select>

                <select wire:model.live="statusFilter" class="bg-gray-100 border-none rounded-lg px-3 py-2 text-sm focus:ring-0">
                    <option value="">All Status</option>
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                </select>

                <select wire:model.live="perPage" class="bg-gray-100 border-none rounded-lg px-3 py-2 text-sm focus:ring-0">
                    <option value="10">10 per page</option>
                    <option value="25">25 per page</option>
                    <option value="50">50 per page</option>
                </select>
            </div>
        </div>
    </div>

    <!-- Banners Table -->
    <div class="bg-white rounded-lg border border-gray-200 overflow-hidden">
        <!-- Table Header -->
        <div class="border-b border-gray-200">
            <div class="grid grid-cols-12 gap-4 px-6 py-3 bg-gray-50 text-xs font-medium text-gray-500 uppercase tracking-wider">
                <div class="col-span-2">Banner</div>
                <div class="col-span-3">Details</div>
                <div class="col-span-2">Type</div>
                <div class="col-span-2">Date Range</div>
                <div class="col-span-1">Status</div>
                <div class="col-span-2 text-center">Actions</div>
            </div>
        </div>

        <!-- Table Body -->
        <div class="divide-y divide-gray-200">
            @if($banners->count() > 0)
                @foreach($banners as $banner)
                <div class="grid grid-cols-12 gap-4 px-6 py-4 items-center hover:bg-gray-50 transition-colors">
                    <!-- Banner Image -->
                    <div class="col-span-2">
                        <div class="flex items-center space-x-3">
                            @if($banner->image)
                                <img src="{{ Storage::url($banner->image) }}" 
                                     alt="{{ $banner->title }}" 
                                     class="w-16 h-12 rounded-lg object-cover border border-gray-200">
                            @else
                                <div class="w-16 h-12 bg-gray-100 rounded-lg flex items-center justify-center border border-gray-200">
                                    <i class="fas fa-image text-gray-400"></i>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Banner Details -->
                    <div class="col-span-3">
                        <p class="text-sm font-medium text-gray-900">{{ $banner->title }}</p>
                        @if($banner->sub_title)
                            <p class="text-sm text-gray-600">{{ $banner->sub_title }}</p>
                        @endif
                        @if($banner->url)
                            <p class="text-xs text-blue-600 truncate" title="{{ $banner->url }}">
                                <i class="fas fa-link mr-1"></i>
                                {{ Str::limit($banner->url, 30) }}
                            </p>
                        @endif
                    </div>

                    <!-- Type -->
                    <div class="col-span-2">
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $banner->type_badge }}">
                            <i class="fas fa-tag mr-1 text-xs"></i>
                            {{ $banner->display_type }}
                        </span>
                    </div>

                    <!-- Date Range -->
                    <div class="col-span-2">
                        @if($banner->has_date_restrictions)
                            <div class="text-sm text-gray-600 space-y-1">
                                @if($banner->start_date)
                                    <div class="flex items-center space-x-1">
                                        <i class="fas fa-play text-green-500 text-xs"></i>
                                        <span>{{ $banner->start_date->format('M d, Y') }}</span>
                                    </div>
                                @endif
                                @if($banner->end_date)
                                    <div class="flex items-center space-x-1">
                                        <i class="fas fa-stop text-red-500 text-xs"></i>
                                        <span>{{ $banner->end_date->format('M d, Y') }}</span>
                                    </div>
                                    @if($banner->days_remaining !== null)
                                        <div class="text-xs {{ $banner->days_remaining < 0 ? 'text-red-600' : ($banner->days_remaining <= 7 ? 'text-orange-600' : 'text-green-600') }}">
                                            {{ $banner->days_remaining < 0 ? 'Expired' : (round($banner->days_remaining) . ' days left') }}
                                        </div>
                                    @endif
                                @endif
                            </div>
                        @else
                            <span class="text-sm text-gray-400">No date restrictions</span>
                        @endif
                    </div>

                    <!-- Status -->
                    <div class="col-span-1">
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $banner->status_badge }}">
                            <i class="fas fa-circle text-[8px] mr-1"></i>
                            {{ $banner->status_text }}
                        </span>
                    </div>

                    <!-- Actions -->
                    <div class="col-span-2">
                        <div class="flex items-center justify-center space-x-2">
                            <button 
                                wire:click="edit({{ $banner->id }})"
                                wire:loading.attr="disabled"
                                class="px-3 py-1 bg-blue-100 text-blue-700 rounded-md hover:bg-blue-200 transition-colors text-xs font-medium flex items-center space-x-1 disabled:opacity-50"
                                title="Edit Banner"
                            >
                                <span wire:loading.remove wire:target="edit({{ $banner->id }})">
                                    <i class="fas fa-edit text-xs"></i>
                                    <span>Edit</span>
                                </span>
                                <span wire:loading wire:target="edit({{ $banner->id }})" class="flex items-center space-x-1">
                                    <div class="animate-spin rounded-full h-3 w-3 border-b-2 border-blue-700"></div>
                                    <span>Loading...</span>
                                </span>
                            </button>
                            
                            <button 
                                wire:click="delete({{ $banner->id }})"
                                wire:confirm="Are you sure you want to delete this banner?"
                                wire:loading.attr="disabled"
                                class="px-3 py-1 bg-red-100 text-red-700 rounded-md hover:bg-red-200 transition-colors text-xs font-medium flex items-center space-x-1 disabled:opacity-50"
                                title="Delete Banner"
                            >
                                <span wire:loading.remove wire:target="delete({{ $banner->id }})">
                                    <i class="fas fa-trash text-xs"></i>
                                    <span>Delete</span>
                                </span>
                                <span wire:loading wire:target="delete({{ $banner->id }})" class="flex items-center space-x-1">
                                    <div class="animate-spin rounded-full h-3 w-3 border-b-2 border-red-700"></div>
                                    <span>Deleting...</span>
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
                @endforeach
            @else
                <div class="px-6 py-12 text-center">
                    <i class="fas fa-images text-4xl text-gray-300 mb-3"></i>
                    <p class="text-gray-500">No banners found.</p>
                    @if($search || $typeFilter || $statusFilter)
                        <p class="text-sm text-gray-400 mt-1">Try adjusting your search criteria</p>
                    @endif
                </div>
            @endif
        </div>

        <!-- Pagination -->
        @if($banners->hasPages())
            <div class="border-t border-gray-200 px-6 py-4 bg-gray-50">
                {{ $banners->links() }}
            </div>
        @endif
    </div>

    <!-- Create/Edit Modal -->
    @if($showForm)
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 z-50 flex items-start justify-center pt-20 px-4"
         wire:loading.class="opacity-50"
         wire:target="create,edit,save">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-2xl max-h-[90vh] overflow-hidden">
            <!-- Modal Header with Loading State -->
            <div class="flex justify-between items-center px-6 py-4 border-b border-gray-200">
                <div class="flex items-center">
                    <h3 class="text-lg font-semibold text-gray-900">
                        {{ $formType === 'create' ? 'Create New Banner' : 'Edit Banner' }}
                    </h3>
                    <div wire:loading wire:target="create,edit" class="ml-3">
                        <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-orange-500"></div>
                    </div>
                </div>
                <button wire:click="resetForm" 
                        class="text-gray-400 hover:text-gray-600 transition-colors"
                        wire:loading.attr="disabled" 
                        wire:target="create,edit,save">
                    <i class="fas fa-times"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="p-6 overflow-y-auto max-h-[70vh]">
                <form wire:submit="save" class="space-y-6">
                    <!-- Basic Information -->
                    <div class="grid grid-cols-1 gap-6">
                        <!-- Title -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Banner Title *</label>
                            <input 
                                type="text" 
                                wire:model="title"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-orange-500 disabled:opacity-50"
                                placeholder="Enter banner title"
                                wire:loading.attr="disabled" 
                                wire:target="create,edit,save"
                            >
                            @error('title') 
                                <span class="text-red-500 text-xs">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Sub Title -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Sub Title</label>
                            <input 
                                type="text" 
                                wire:model="sub_title"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-orange-500 disabled:opacity-50"
                                placeholder="Optional sub title or description"
                                wire:loading.attr="disabled" 
                                wire:target="create,edit,save"
                            >
                            @error('sub_title') 
                                <span class="text-red-500 text-xs">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Image -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">
                                Banner Image {{ $formType === 'create' ? '*' : '' }}
                            </label>
                            <div class="flex items-center space-x-4">
                                @if($image)
                                    <div class="flex items-center space-x-2">
                                        <img src="{{ $image->temporaryUrl() }}" alt="Preview" class="w-32 h-20 object-cover rounded border">
                                        <button type="button" wire:click="$set('image', null)" class="text-red-600 hover:text-red-800 text-sm">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                @elseif($formType === 'edit' && $bannerId)
                                    @php
                                        $banner = \App\Models\Banner::find($bannerId);
                                    @endphp
                                    @if($banner && $banner->image)
                                        <div class="flex items-center space-x-2">
                                            <img src="{{ Storage::url($banner->image) }}" alt="{{ $banner->title }}" class="w-32 h-20 object-cover rounded border">
                                            <button type="button" wire:click="removeImage" class="text-red-600 hover:text-red-800 text-sm">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    @endif
                                @endif
                                <input 
                                    type="file" 
                                    wire:model="image"
                                    class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-orange-50 file:text-orange-700 hover:file:bg-orange-100"
                                    accept="image/*"
                                >
                            </div>
                            @error('image') 
                                <span class="text-red-500 text-xs">{{ $message }}</span>
                            @enderror
                            <p class="text-xs text-gray-500 mt-1">Recommended: 1200x400px for home banners, 300x250px for sidebars</p>
                        </div>

                        <!-- Type -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Banner Type *</label>
                            <select 
                                wire:model="type"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-orange-500 disabled:opacity-50"
                                wire:loading.attr="disabled" 
                                wire:target="create,edit,save"
                            >
                                <option value="home">Home Page</option>
                                <option value="category">Category Page</option>
                                <option value="product">Product Page</option>
                                <option value="promotional">Promotional</option>
                                <option value="sidebar">Sidebar</option>
                                <option value="footer">Footer</option>
                            </select>
                            @error('type') 
                                <span class="text-red-500 text-xs">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- URL -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Target URL</label>
                            <input 
                                type="url" 
                                wire:model="url"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-orange-500 disabled:opacity-50"
                                placeholder="https://example.com/page"
                                wire:loading.attr="disabled" 
                                wire:target="create,edit,save"
                            >
                            @error('url') 
                                <span class="text-red-500 text-xs">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Date Range -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Start Date</label>
                                <input 
                                    type="date" 
                                    wire:model="start_date"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-orange-500 disabled:opacity-50"
                                    wire:loading.attr="disabled" 
                                    wire:target="create,edit,save"
                                >
                                @error('start_date') 
                                    <span class="text-red-500 text-xs">{{ $message }}</span>
                                @enderror
                                <p class="text-xs text-gray-500 mt-1">Leave empty to start immediately</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">End Date</label>
                                <input 
                                    type="date" 
                                    wire:model="end_date"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-orange-500 disabled:opacity-50"
                                    wire:loading.attr="disabled" 
                                    wire:target="create,edit,save"
                                >
                                @error('end_date') 
                                    <span class="text-red-500 text-xs">{{ $message }}</span>
                                @enderror
                                <p class="text-xs text-gray-500 mt-1">Leave empty for no expiration</p>
                            </div>
                        </div>
                    </div>

                    <!-- Form Actions with Loading State -->
                    <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200">
                        <button 
                            type="button"
                            wire:click="resetForm"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-md hover:bg-gray-200 transition-colors disabled:opacity-50"
                            wire:loading.attr="disabled" 
                            wire:target="save"
                        >
                            Cancel
                        </button>
                        <button 
                            type="submit"
                            class="px-4 py-2 text-sm font-medium text-white bg-orange-500 rounded-md hover:bg-orange-600 transition-colors flex items-center space-x-2 disabled:opacity-50 disabled:cursor-not-allowed"
                            wire:loading.attr="disabled" 
                            wire:target="save"
                        >
                            <span wire:loading.remove wire:target="save">
                                {{ $formType === 'create' ? 'Create Banner' : 'Update Banner' }}
                            </span>
                            <span wire:loading wire:target="save" class="flex items-center space-x-2">
                                <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-white"></div>
                                <span>Saving...</span>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif

    <!-- Flash Messages -->
    @if (session()->has('success'))
        <div x-data="{ show: true }" 
             x-show="show" 
             x-init="setTimeout(() => show = false, 3000)"
             class="fixed bottom-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg transition-all duration-300">
            <div class="flex items-center space-x-2">
                <i class="fas fa-check-circle"></i>
                <span>{{ session('success') }}</span>
            </div>
        </div>
    @endif

    @if (session()->has('error'))
        <div x-data="{ show: true }" 
             x-show="show" 
             x-init="setTimeout(() => show = false, 5000)"
             class="fixed bottom-4 right-4 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg transition-all duration-300">
            <div class="flex items-center space-x-2">
                <i class="fas fa-exclamation-circle"></i>
                <span>{{ session('error') }}</span>
            </div>
        </div>
    @endif
</div>