<div>
    <x-slot name="header">Leads Management</x-slot>
    
    <div class="space-y-6">
        <!-- Header Section -->
        <div class="bg-white rounded-lg border border-gray-200 p-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Leads Management</h1>
                    <p class="text-gray-600 mt-1">Manage and view all wholesale applications</p>
                </div>
                <div class="flex space-x-3">
                    <button wire:click="$refresh" class="px-4 py-2 bg-gray-100 text-gray-700 rounded-md hover:bg-gray-200 transition-colors flex items-center space-x-2 text-sm font-medium">
                        <i class="fas fa-refresh"></i>
                        <span>Refresh</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Filters and Search -->
        <div class="bg-white rounded-lg border border-gray-200 p-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Search -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Search Leads</label>
                    <input type="text" 
                           wire:model.live="search" 
                           placeholder="Search by name, email, company..."
                           class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>

                <!-- Source Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Filter by Source</label>
                    <select wire:model.live="sourceFilter" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">All Sources</option>
                        @foreach($sources as $source)
                            <option value="{{ $source }}">{{ ucfirst($source) }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Per Page -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Items Per Page</label>
                    <select wire:model.live="perPage" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Leads Table -->
        <div class="bg-white rounded-lg border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th wire:click="sortBy('firstname')" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer hover:bg-gray-100">
                                <div class="flex items-center space-x-1">
                                    <span>Name</span>
                                    @if($sortField === 'firstname')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} text-xs"></i>
                                    @else
                                        <i class="fas fa-sort text-xs text-gray-300"></i>
                                    @endif
                                </div>
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Company
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Contact
                            </th>
                            <th wire:click="sortBy('source')" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer hover:bg-gray-100">
                                <div class="flex items-center space-x-1">
                                    <span>Source</span>
                                    @if($sortField === 'source')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} text-xs"></i>
                                    @else
                                        <i class="fas fa-sort text-xs text-gray-300"></i>
                                    @endif
                                </div>
                            </th>
                            <th wire:click="sortBy('created_at')" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer hover:bg-gray-100">
                                <div class="flex items-center space-x-1">
                                    <span>Submitted</span>
                                    @if($sortField === 'created_at')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} text-xs"></i>
                                    @else
                                        <i class="fas fa-sort text-xs text-gray-300"></i>
                                    @endif
                                </div>
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($leads as $lead)
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 h-10 w-10 bg-blue-100 rounded-full flex items-center justify-center">
                                            <i class="fas fa-user text-blue-600"></i>
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ $lead->firstname }} {{ $lead->lastname }}
                                            </div>
                                            <div class="text-sm text-gray-500">
                                                ID: {{ $lead->id }}
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">{{ $lead->companyname ?? 'N/A' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">{{ $lead->email ?? 'N/A' }}</div>
                                    <div class="text-sm text-gray-500">{{ $lead->phone ?? 'N/A' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full 
                                        {{ $lead->source === 'website' ? 'bg-green-100 text-green-800' : 
                                           ($lead->source === 'seo' ? 'bg-blue-100 text-blue-800' : 
                                           'bg-gray-100 text-gray-800') }}">
                                        {{ ucfirst($lead->source) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $lead->created_at->format('M j, Y') }}<br>
                                    <span class="text-gray-400">{{ $lead->created_at->format('g:i A') }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex items-center space-x-2">
                                        <button wire:click="viewLead({{ $lead->id }})" 
                                                class="px-3 py-1 bg-blue-100 text-blue-600 hover:text-blue-900 flex items-center space-x-1 rounded-md hover:bg-blue-200 transition-colors text-xs font-medium">
                                            <i class="fas fa-eye text-xs"></i>
                                            <span>View</span>
                                        </button>
                                        @if($lead->permit_doc)
                                            <button wire:click="downloadPermitDoc({{ $lead->id }})" 
                                                    class="px-3 py-1 bg-green-100 text-green-600 hover:text-green-900 flex items-center space-x-1 rounded-md hover:bg-green-200 transition-colors text-xs font-medium">
                                                <i class="fas fa-download text-xs"></i>
                                                <span>Document</span>
                                            </button>
                                        @endif
                                        
                                        {{-- <button 
                                            wire:click="deleteLead({{ $lead->id }})"
                                            wire:confirm="Are you sure you want to delete this lead?"
                                            wire:loading.attr="disabled"
                                            class="px-3 py-1 bg-red-100 text-red-700 rounded-md hover:bg-red-200 transition-colors text-xs font-medium flex items-center space-x-1 disabled:opacity-50"
                                            title="Delete Lead"
                                        >
                                            <span wire:loading.remove wire:target="deleteLead({{ $lead->id }})">
                                                <i class="fas fa-trash text-xs"></i>
                                                <span>Delete</span>
                                            </span>
                                            <span wire:loading wire:target="delete({{ $lead->id }})" class="flex items-center space-x-1">
                                                <div class="animate-spin rounded-full h-3 w-3 border-b-2 border-red-700"></div>
                                                <span>Deleting...</span>
                                            </span>
                                        </button> --}}
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-8 text-center">
                                    <div class="text-gray-500">
                                        <i class="fas fa-inbox text-4xl mb-3 text-gray-300"></i>
                                        <p class="text-lg">No leads found</p>
                                        <p class="text-sm mt-1">When leads are submitted, they will appear here.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($leads->hasPages())
                <div class="bg-white px-6 py-4 border-t border-gray-200">
                    {{ $leads->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- View Lead Modal -->
    @if($showViewModal && $viewingLead)
        <div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center p-4 z-50">
            <div class="bg-white rounded-lg shadow-xl max-w-4xl w-full max-h-[90vh] overflow-y-auto">
                <!-- Modal Header -->
                <div class="flex justify-between items-center p-6 border-b border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900">Lead Details</h3>
                    <button wire:click="closeViewModal" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>

                <!-- Modal Content -->
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Personal Information -->
                        <div class="space-y-4">
                            <h4 class="text-lg font-semibold text-gray-900 border-b pb-2">Personal Information</h4>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="text-sm font-medium text-gray-500">First Name</label>
                                    <p class="text-sm text-gray-900">{{ $viewingLead->firstname }}</p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500">Last Name</label>
                                    <p class="text-sm text-gray-900">{{ $viewingLead->lastname }}</p>
                                </div>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Company</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->companyname ?? 'N/A' }}</p>
                            </div>
                        </div>

                        <!-- Contact Information -->
                        <div class="space-y-4">
                            <h4 class="text-lg font-semibold text-gray-900 border-b pb-2">Contact Information</h4>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Email</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->email ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Phone</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->phone ?? 'N/A' }}</p>
                            </div>
                        </div>

                        <!-- Address Information -->
                        <div class="space-y-4">
                            <h4 class="text-lg font-semibold text-gray-900 border-b pb-2">Address</h4>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Primary Address</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->address_primary ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Secondary Address</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->address_secondary ?? 'N/A' }}</p>
                            </div>
                            <div class="grid grid-cols-3 gap-4">
                                <div>
                                    <label class="text-sm font-medium text-gray-500">City</label>
                                    <p class="text-sm text-gray-900">{{ $viewingLead->city ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500">State</label>
                                    <p class="text-sm text-gray-900">{{ $viewingLead->state ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500">Country</label>
                                    <p class="text-sm text-gray-900">{{ $viewingLead->country ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Business Information -->
                        <div class="space-y-4">
                            <h4 class="text-lg font-semibold text-gray-900 border-b pb-2">Business Information</h4>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Employee ID</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->employeeid ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Seller Permit</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->seller_permit ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Business Duration</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->period ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Sales Location</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->location ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Reference Source</label>
                                <p class="text-sm text-gray-900">{{ $viewingLead->reference ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Document Section -->
                    @if($viewingLead->permit_doc)
                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <h4 class="text-lg font-semibold text-gray-900 mb-4">Attached Document</h4>
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                <div class="flex items-center space-x-3">
                                    <i class="fas fa-file-pdf text-red-500 text-xl"></i>
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">Permit Document</p>
                                        <p class="text-xs text-gray-500">Uploaded on {{ $viewingLead->created_at->format('M j, Y') }}</p>
                                    </div>
                                </div>
                                <button wire:click="downloadPermitDoc({{ $viewingLead->id }})" 
                                        class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors flex items-center space-x-2">
                                    <i class="fas fa-download"></i>
                                    <span>Download</span>
                                </button>
                            </div>
                        </div>
                    @endif

                    <!-- Meta Information -->
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm">
                            <div>
                                <label class="font-medium text-gray-500">Source</label>
                                <p class="text-gray-900">{{ ucfirst($viewingLead->source) }}</p>
                            </div>
                            <div>
                                <label class="font-medium text-gray-500">Submitted</label>
                                <p class="text-gray-900">{{ $viewingLead->created_at->format('M j, Y g:i A') }}</p>
                            </div>
                            <div>
                                <label class="font-medium text-gray-500">Last Updated</label>
                                <p class="text-gray-900">{{ $viewingLead->updated_at->format('M j, Y g:i A') }}</p>
                            </div>
                            <div>
                                <label class="font-medium text-gray-500">Emails Sent</label>
                                <p class="text-gray-900">{{ $viewingLead->mail_count }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Modal Footer -->
                <div class="flex justify-end space-x-3 p-6 border-t border-gray-200">
                    <button wire:click="closeViewModal" 
                            class="px-4 py-2 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition-colors">
                        Close
                    </button>
                    <button wire:click="deleteLead({{ $viewingLead->id }})" 
                            wire:confirm="Are you sure you want to delete this lead?"
                            class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition-colors">
                        Delete Lead
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>