<div class="p-6 bg-gray-50 min-h-screen">
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Website Analytics Dashboard</h1>
        <p class="text-gray-600">Select a website to view performance data</p>
    </div>

    <!-- Error Message -->
    @if($error)
    <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg">
        <div class="flex items-center">
            <svg class="w-5 h-5 text-red-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <span class="text-red-800">{{ $error }}</span>
        </div>
    </div>
    @endif

    <!-- Site Selection Card -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-lg font-semibold text-gray-700">Select Website</h2>
                <p class="text-sm text-gray-500">Choose which website data you want to view</p>
            </div>
            
            <!-- Site Dropdown -->
            @if($availableSites && $availableSites->count() > 0)
            <div class="w-64">
                <select 
                    wire:model="selectedSite"
                    wire:change="loadSiteData"
                    id="siteSelector"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                >
                    @foreach($availableSites as $website)
                        <option value="{{ $website->id }}" {{ $selectedSite == $website->id ? 'selected' : '' }}>{{ $website->name }}</option>
                    @endforeach
                </select>
            </div>
            @else
            <div class="text-center py-4">
                <p class="text-yellow-600">No websites found. Please add websites first.</p>
                <a href="/websites" class="text-blue-600 hover:text-blue-800 underline mt-2 inline-block">
                    Go to Websites Management
                </a>
            </div>
            @endif
        </div>
    </div>

    <!-- Loading Overlay (Hidden by default) -->
    <div id="loadingOverlay" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-xl shadow-2xl p-8 mx-4 max-w-md w-full">
            <div class="flex flex-col items-center text-center">
                <!-- Animated Spinner -->
                <div class="relative mb-6">
                    <div class="animate-spin rounded-full h-20 w-20 border-b-2 border-blue-600"></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <div class="animate-pulse text-blue-600">
                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                    </div>
                </div>
                
                <!-- Loading Text -->
                <h3 class="text-xl font-semibold text-gray-800 mb-2">Fetching Website Data</h3>
                <p class="text-gray-600 mb-4">Please wait while we retrieve data from APIs</p>
                
                <!-- Progress Indicators -->
                <div class="w-full bg-gray-200 rounded-full h-2 mb-2">
                    <div class="bg-blue-600 h-2 rounded-full animate-pulse"></div>
                </div>
                <p class="text-sm text-gray-500">This may take a few seconds...</p>
            </div>
        </div>
    </div>

    <!-- Data Display Section -->
    <div id="dataContainer">
        @if($selectedSite && count($siteData) > 0)
        
        <!-- Current Site Info -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    @if($siteData['website_image'])
                        <img src="{{ Storage::url($siteData['website_image']) }}" alt="{{ $siteData['website_name'] }}" class="w-50 rounded-lg mr-4 object-cover">
                    @else
                        <div class="w-12 h-12 bg-gray-200 rounded-lg flex items-center justify-center mr-4">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                            </svg>
                        </div>
                    @endif
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">
                            Currently Viewing: {{ $siteData['website_name'] }}
                        </h3>
                        <p class="text-gray-600">
                            <a href="{{ $siteData['website_url'] }}" target="_blank" class="text-blue-600 hover:text-blue-800">
                                {{ $siteData['website_url'] }}
                            </a>
                        </p>
                        <p class="text-sm text-gray-500">Data fetched from APIs: {{ \Carbon\Carbon::parse($siteData['timestamp'])->format('M d, Y H:i') }}</p>
                    </div>
                </div>
                <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-medium">
                    Live Data
                </span>
            </div>
        </div>
        <!-- Leads Section -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <!-- Total Leads Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-blue-100 rounded-lg">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Total Leads</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['total_leads']) }}</p>
                    </div>
                </div>
            </div>

            <!-- New Leads Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-green-100 rounded-lg">
                        <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">New Leads (Today)</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['today_leads']) }}</p>
                    </div>
                </div>
            </div>

            <!-- Yesterday Leads Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-purple-100 rounded-lg">
                        <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Yesterday Leads</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['yesterday_leads']) }}</p>
                    </div>
                </div>
            </div>
            
            <!-- Current Month Leads Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-blue-100 rounded-lg">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Current Month Leads</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['current_month_leads']) }}</p>
                    </div>
                </div>
            </div>

            <!-- Last Month Leads Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-green-100 rounded-lg">
                        <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Last month Leads</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['last_month_leads']) }}</p>
                    </div>
                </div>
            </div>

            <!-- Monthly Growth Leads Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-purple-100 rounded-lg">
                        <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Monthly Growth Rate</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['monthly_growth_rate']) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Content Section -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <!-- Blogs Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-indigo-100 rounded-lg">
                        <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Total Blogs</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['total_blogs']) }}</p>
                        <p class="text-xs text-gray-500 mt-1">
                            {{ $siteData['published_blogs'] }} Published • {{ $siteData['draft_blogs'] }} Draft
                        </p>
                    </div>
                </div>
            </div>

            <!-- Categories Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-orange-100 rounded-lg">
                        <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Categories</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['total_categories']) }}</p>
                        <p class="text-xs text-gray-500 mt-1">{{ $siteData['active_categories'] }} Active</p>
                    </div>
                </div>
            </div>

            <!-- Products Card -->
            <div class="bg-white rounded-lg shadowSm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-teal-100 rounded-lg">
                        <svg class="w-6 h-6 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Products</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['total_products']) }}</p>
                        <p class="text-xs text-gray-500 mt-1">
                            {{ $siteData['published_products'] }} Published • {{ $siteData['out_of_stock'] }} Out of Stock
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Performance Metrics -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <!-- Conversion Rate Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 bg-pink-100 rounded-lg">
                        <svg class="w-6 h-6 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Conversion Rate</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($siteData['conversion_rate'], 1) }}%</p>
                    </div>
                </div>
            </div>

            <!-- Growth Rate Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center">
                    <div class="p-3 {{ $siteData['growth_rate'] >= 0 ? 'bg-green-100' : 'bg-red-100' }} rounded-lg">
                        <svg class="w-6 h-6 {{ $siteData['growth_rate'] >= 0 ? 'text-green-600' : 'text-red-600' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Growth Rate</p>
                        <p class="text-2xl font-bold {{ $siteData['growth_rate'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                            {{ $siteData['growth_rate'] >= 0 ? '+' : '' }}{{ $siteData['growth_rate'] }}%
                        </p>
                    </div>
                </div>
            </div>
        </div>

        
        @endif
    </div>

    <!-- Empty States -->
    @if(!$availableSites || $availableSites->count() === 0)
    <div class="bg-white rounded-lg shadow-md p-8 text-center">
        <svg class="w-16 h-16 mx-auto text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        <h3 class="mt-4 text-lg font-medium text-gray-900">No Websites Found</h3>
        <p class="mt-2 text-gray-500">Please add some websites to view their data.</p>
        <a href="/websites" class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Add Websites
        </a>
    </div>
    @endif
</div>

<!-- jQuery and Custom Script -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    let isLoading = false;
    
    // Function to initialize loading events
    function initializeLoading() {
        console.log('Initializing loading events...');
        
        // Remove any existing event listeners
        $('#siteSelector').off('change.loading');
        
        // Add event listener for dropdown changes
        $('#siteSelector').on('change.loading', function() {
            console.log('Dropdown changed, value:', $(this).val());
            if (!isLoading && $(this).val()) {
                console.log('Showing loading...');
                showLoading();
                
                // Safety timeout to hide loading if something goes wrong
                setTimeout(function() {
                    if (isLoading) {
                        console.log('Safety timeout triggered - hiding loading');
                        hideLoading();
                    }
                }, 30000); // 30 second timeout
            }
        });
    }
    
    // Initialize when page loads
    initializeLoading();
    
    // Re-initialize after Livewire updates
    document.addEventListener('livewire:load', function() {
        console.log('Livewire loaded - reinitializing loading');
        initializeLoading();
    });
    
    document.addEventListener('livewire:update', function() {
        console.log('Livewire updated - reinitializing loading');
        setTimeout(initializeLoading, 100);
    });
    
    // Listen for Livewire custom events
    document.addEventListener('livewire:init', function() {
        console.log('Livewire init - setting up event listeners');
        
        Livewire.on('loadingStarted', () => {
            console.log('Livewire: loadingStarted event received');
            if (!isLoading) {
                showLoading();
            }
        });
        
        Livewire.on('loadingFinished', () => {
            console.log('Livewire: loadingFinished event received');
            hideLoading();
        });
    });
    
    // Show loading overlay
    function showLoading() {
        if (isLoading) return;
        
        isLoading = true;
        console.log('Showing loading overlay');
        $('#loadingOverlay').removeClass('hidden');
        $('#dataContainer').addClass('opacity-50 pointer-events-none');
        $('#siteSelector').prop('disabled', true);
    }
    
    // Hide loading overlay
    function hideLoading() {
        if (!isLoading) return;
        
        isLoading = false;
        console.log('Hiding loading overlay');
        $('#loadingOverlay').addClass('hidden');
        $('#dataContainer').removeClass('opacity-50 pointer-events-none');
        $('#siteSelector').prop('disabled', false);
    }
    
    // Initial state check
    console.log('Initial data container children:', $('#dataContainer').children().length);
});
</script>