<div class="p-6 space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Analytics Dashboard</h2>
            <p class="text-gray-600 mt-1">Understand your audience and traffic patterns</p>
        </div>
        <div class="flex gap-3">
            <select wire:model.live="daysFilter" 
                    class="border border-gray-300 rounded-lg px-4 py-2 bg-white text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                <option value="7">Last 7 days</option>
                <option value="30">Last 30 days</option>
                <option value="90">Last 90 days</option>
            </select>
            <button wire:click="refreshData" 
                    wire:loading.attr="disabled"
                    class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors disabled:opacity-50 flex items-center gap-2">
                <svg wire:loading.remove class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                <svg wire:loading class="w-4 h-4 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                Refresh
            </button>
        </div>
    </div>

    <!-- Loading State -->
    @if($loading)
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-8 text-center">
        <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600 mx-auto"></div>
        <p class="mt-4 text-gray-600 font-medium">Loading analytics data...</p>
    </div>
    @endif

    <!-- Error State -->
    @if($error)
    <div class="bg-red-50 border border-red-200 rounded-xl p-4">
        <div class="flex items-center">
            <svg class="h-5 w-5 text-red-400 mr-3" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
            </svg>
            <div>
                <h3 class="text-sm font-medium text-red-800">Error Loading Data</h3>
                <p class="text-sm text-red-600 mt-1">{{ $error }}</p>
            </div>
        </div>
    </div>
    @endif

    @if(!$loading)
    <!-- Tabs -->
    <div class="border-b border-gray-200">
        <nav class="-mb-px flex space-x-8">
            @foreach(['overview' => 'Overview', 'analytics' => 'Analytics', 'search' => 'Search Console'] as $tab => $label)
            <button 
                wire:click="switchTab('{{ $tab }}')"
                @class([
                    'whitespace-nowrap py-3 px-1 border-b-2 font-medium text-sm transition-colors duration-200',
                    'border-blue-600 text-blue-600' => $activeTab === $tab,
                    'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' => $activeTab !== $tab
                ])
            >
                {{ $label }}
                @if($tabLoading && $activeTab === $tab)
                <svg class="inline w-4 h-4 ml-1 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                @endif
            </button>
            @endforeach
        </nav>
    </div>

    <!-- Tab Content -->
    <div class="transition-opacity duration-300 @if($tabLoading) opacity-50 @else opacity-100 @endif">
        <!-- Overview Tab -->
        @if($activeTab === 'overview')
        <div class="space-y-6">
            <!-- Key Metrics -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Active Users</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">{{ $this->activeUsers }}</p>
                        </div>
                        <div class="p-3 bg-blue-50 rounded-lg">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">Real-time users on site</p>
                </div>

                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Total Sessions</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">{{ number_format($this->totalSessions) }}</p>
                        </div>
                        <div class="p-3 bg-green-50 rounded-lg">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">Last {{ $daysFilter }} days</p>
                </div>

                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Total Users</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">{{ number_format($this->totalUsers) }}</p>
                        </div>
                        <div class="p-3 bg-purple-50 rounded-lg">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">Last {{ $daysFilter }} days</p>
                </div>

                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Avg. Session</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">
                                @php
                                    $avgDuration = !empty($topPages) ? array_sum(array_column($topPages, 'avg_duration')) / count($topPages) : 0;
                                @endphp
                                {{ round($avgDuration, 1) }}s
                            </p>
                        </div>
                        <div class="p-3 bg-orange-50 rounded-lg">
                            <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">Average session duration</p>
                </div>
            </div>

            <!-- Charts and Maps Row -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Traffic Chart -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Traffic Overview</h3>
                    <div class="h-64">
                        <canvas id="trafficChart" wire:ignore></canvas>
                    </div>
                </div>

                <!-- Geo Location -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Top Locations</h3>
                    <div class="space-y-3 max-h-64 overflow-y-auto">
                        @forelse($this->topCountries as $country => $sessions)
                        <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                </div>
                                <span class="font-medium text-gray-900">{{ $country }}</span>
                            </div>
                            <span class="text-sm font-semibold text-gray-700">{{ number_format($sessions) }} sessions</span>
                        </div>
                        @empty
                        <p class="text-gray-500 text-center py-4">No location data available</p>
                        @endforelse
                    </div>
                </div>
            </div>

            <!-- Devices and Top Pages -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Device Distribution -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Device Distribution</h3>
                    <div class="h-64">
                        <canvas id="deviceChart" wire:ignore></canvas>
                    </div>
                </div>

                <!-- Top Pages -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Top Pages</h3>
                    <div class="space-y-3 max-h-64 overflow-y-auto">
                        @forelse(array_slice($topPages, 0, 5) as $page)
                        <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors">
                            <div class="flex-1 min-w-0">
                                <p class="font-medium text-gray-900 truncate">{{ $page['title'] ?? 'N/A' }}</p>
                                <p class="text-sm text-gray-500 truncate">{{ $page['path'] ?? 'N/A' }}</p>
                            </div>
                            <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded text-sm font-medium whitespace-nowrap ml-2">
                                {{ number_format($page['views'] ?? 0) }} views
                            </span>
                        </div>
                        @empty
                        <p class="text-gray-500 text-center py-4">No page data available</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Analytics Tab -->
        @if($activeTab === 'analytics')
        <div class="space-y-6">
            <!-- Traffic Table -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Detailed Traffic Data</h3>
                @if(!empty($trafficData))
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Sessions</th>
                                <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Users</th>
                                <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Pageviews</th>
                                <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Bounce Rate</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($trafficData as $data)
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-4 py-3 text-sm text-gray-900">{{ $data['date'] ?? 'N/A' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">{{ number_format($data['sessions'] ?? 0) }}</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">{{ number_format($data['users'] ?? 0) }}</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">{{ number_format($data['pageviews'] ?? 0) }}</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">{{ round($data['bounce_rate'] ?? 0, 2) }}%</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <p class="text-gray-500 text-center py-8">No traffic data available</p>
                @endif
            </div>
        </div>
        @endif
        <!-- Search Console Tab -->
        @if($activeTab === 'search')
            <div class="space-y-6">
                <!-- Top Queries -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold mb-4">Top Search Queries</h3>
                    @if(!empty($topQueries))
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead>
                                    <tr>
                                        <th class="px-4 py-2 text-left">Query</th>
                                        <th class="px-4 py-2 text-right">Clicks</th>
                                        <th class="px-4 py-2 text-right">Impressions</th>
                                        <th class="px-4 py-2 text-right">CTR</th>
                                        <th class="px-4 py-2 text-right">Position</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($topQueries as $query)
                                        <tr>
                                            <td class="px-4 py-2 font-medium">{{ $query['query'] ?? 'N/A' }}</td>
                                            <td class="px-4 py-2 text-right">{{ number_format($query['clicks'] ?? 0) }}</td>
                                            <td class="px-4 py-2 text-right">{{ number_format($query['impressions'] ?? 0) }}</td>
                                            <td class="px-4 py-2 text-right">{{ $query['ctr'] ?? 0 }}%</td>
                                            <td class="px-4 py-2 text-right">{{ $query['position'] ?? 0 }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-gray-500 text-center py-4">No search query data available</p>
                    @endif
                </div>

                <!-- Top Pages by Search -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold mb-4">Top Pages in Search</h3>
                    @if(!empty($searchTopPages))
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead>
                                    <tr>
                                        <th class="px-4 py-2 text-left">Page</th>
                                        <th class="px-4 py-2 text-right">Clicks</th>
                                        <th class="px-4 py-2 text-right">Impressions</th>
                                        <th class="px-4 py-2 text-right">CTR</th>
                                        <th class="px-4 py-2 text-right">Position</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($searchTopPages as $page)
                                        <tr>
                                            <td class="px-4 py-2">
                                                <p class="font-medium truncate max-w-xs">{{ $page['page'] ?? 'N/A' }}</p>
                                            </td>
                                            <td class="px-4 py-2 text-right">{{ number_format($page['clicks'] ?? 0) }}</td>
                                            <td class="px-4 py-2 text-right">{{ number_format($page['impressions'] ?? 0) }}</td>
                                            <td class="px-4 py-2 text-right">{{ $page['ctr'] ?? 0 }}%</td>
                                            <td class="px-4 py-2 text-right">{{ $page['position'] ?? 0 }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-gray-500 text-center py-4">No search page data available</p>
                    @endif
                </div>
            </div>
        @endif

        
    </div>
    @endif
</div>

<!-- Load Chart.js from CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    // Wait for Livewire to initialize and ensure Chart is available
    document.addEventListener('livewire:initialized', function() {
        // Wait a bit to ensure Chart.js is loaded
        setTimeout(initializeCharts, 100);
        
        // Reinitialize charts when data changes or when switching to overview tab
        Livewire.on('dataUpdated', function() {
            setTimeout(initializeCharts, 200);
        });
    });

    function initializeCharts() {
        // Check if Chart is available
        if (typeof Chart === 'undefined') {
            console.warn('Chart.js is not loaded yet. Retrying...');
            setTimeout(initializeCharts, 500);
            return;
        }

        // Traffic Chart
        const trafficCtx = document.getElementById('trafficChart');
        if (trafficCtx) {
            // Destroy existing chart instance if it exists
            if (trafficCtx.chart) {
                trafficCtx.chart.destroy();
            }
            
            const trafficData = @json($trafficChartData);
            trafficCtx.chart = new Chart(trafficCtx, {
                type: 'line',
                data: {
                    labels: trafficData.dates || [],
                    datasets: [
                        {
                            label: 'Sessions',
                            data: trafficData.sessions || [],
                            borderColor: '#3b82f6',
                            backgroundColor: 'rgba(59, 130, 246, 0.1)',
                            tension: 0.4,
                            fill: true,
                            borderWidth: 2
                        },
                        {
                            label: 'Users',
                            data: trafficData.users || [],
                            borderColor: '#10b981',
                            backgroundColor: 'rgba(16, 185, 129, 0.1)',
                            tension: 0.4,
                            fill: true,
                            borderWidth: 2
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'top',
                        },
                        tooltip: {
                            mode: 'index',
                            intersect: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                drawBorder: false
                            },
                            ticks: {
                                callback: function(value) {
                                    return value.toLocaleString();
                                }
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    },
                    interaction: {
                        mode: 'nearest',
                        axis: 'x',
                        intersect: false
                    }
                }
            });
        }

        // Device Chart
        const deviceCtx = document.getElementById('deviceChart');
        if (deviceCtx) {
            // Destroy existing chart instance if it exists
            if (deviceCtx.chart) {
                deviceCtx.chart.destroy();
            }
            
            const deviceData = @json($deviceData);
            const labels = deviceData.map(item => item.device);
            const data = deviceData.map(item => item.sessions);
            
            deviceCtx.chart = new Chart(deviceCtx, {
                type: 'doughnut',
                data: {
                    labels: labels,
                    datasets: [{
                        data: data,
                        backgroundColor: [
                            '#3b82f6',
                            '#10b981', 
                            '#f59e0b',
                            '#ef4444',
                            '#8b5cf6'
                        ],
                        borderWidth: 2,
                        borderColor: '#fff',
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '65%',
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                usePointStyle: true,
                                padding: 20
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.parsed;
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = Math.round((value / total) * 100);
                                    return `${label}: ${value.toLocaleString()} (${percentage}%)`;
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    // Fallback: If Livewire doesn't fire the event, try to initialize charts when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initializeCharts);
    } else {
        initializeCharts();
    }
</script>