<div>
    <div class="container mx-auto px-4 py-8">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">Sitemap Generator</h1>
                <p class="text-gray-600 mt-2">
                    Auto-generated sitemap with {{ $urlCounts['total'] }} URLs
                    <span class="text-sm text-gray-500">(Last updated: {{ $lastGenerated }})</span>
                </p>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-3">
                <!-- Regenerate Button -->
                <button wire:click="generateSitemap" 
                        class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg transition-colors">
                    🔄 Regenerate Sitemap
                </button>
                
                <!-- Switch Between HTML/XML -->
                <div class="flex bg-gray-100 rounded-lg p-1">
                    <button wire:click="switchSitemap('html')" 
                            class="px-4 py-2 rounded-lg transition-colors {{ $sitemapType === 'html' ? 'bg-white shadow-sm text-blue-600' : 'text-gray-600' }}">
                        📄 HTML Sitemap
                    </button>
                    <button wire:click="switchSitemap('xml')" 
                            class="px-4 py-2 rounded-lg transition-colors {{ $sitemapType === 'xml' ? 'bg-white shadow-sm text-blue-600' : 'text-gray-600' }}">
                        🔗 XML Sitemap
                    </button>
                </div>
            </div>
        </div>

        <!-- URL Statistics -->
        <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mt-6">
            <div class="text-center p-3 bg-blue-50 rounded-lg">
                <div class="text-2xl font-bold text-blue-600">{{ $urlCounts['static'] }}</div>
                <div class="text-sm text-blue-800">Static Pages</div>
            </div>
            <div class="text-center p-3 bg-green-50 rounded-lg">
                <div class="text-2xl font-bold text-green-600">{{ $urlCounts['posts'] }}</div>
                <div class="text-sm text-green-800">Blog Posts</div>
            </div>
            <div class="text-center p-3 bg-purple-50 rounded-lg">
                <div class="text-2xl font-bold text-purple-600">{{ $urlCounts['categories'] }}</div>
                <div class="text-sm text-purple-800">Categories</div>
            </div>
            <div class="text-center p-3 bg-orange-50 rounded-lg">
                <div class="text-2xl font-bold text-orange-600">{{ $urlCounts['products'] }}</div>
                <div class="text-sm text-orange-800">Products</div>
            </div>
            <div class="text-center p-3 bg-gray-100 rounded-lg">
                <div class="text-2xl font-bold text-gray-700">{{ $urlCounts['total'] }}</div>
                <div class="text-sm text-gray-600">Total URLs</div>
            </div>
        </div>
    </div>

    <!-- Flash Message -->
    @if (session()->has('message'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            {{ session('message') }}
        </div>
    @endif

    <!-- HTML Sitemap -->
    @if($sitemapType === 'html')
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">HTML Sitemap</h2>
        
        <!-- Static Pages -->
        <div class="mb-8">
            <h3 class="text-xl font-semibold text-gray-700 mb-4 border-b pb-2">Main Pages</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                @foreach($staticPages as $page)
                    <a href="{{ $page['url'] }}" 
                       class="block p-3 border border-gray-200 rounded-lg hover:bg-blue-50 hover:border-blue-300 transition-colors">
                        <div class="font-medium text-gray-800">{{ $page['title'] }}</div>
                        <div class="text-sm text-gray-500 mt-1">{{ $page['url'] }}</div>
                    </a>
                @endforeach
            </div>
        </div>

        <!-- Dynamic Content -->
        @foreach($dynamicContent as $type => $items)
            @if(count($items) > 0)
                <div class="mb-8">
                    <h3 class="text-xl font-semibold text-gray-700 mb-4 border-b pb-2 capitalize">
                        {{ $type }} ({{ count($items) }})
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                        @foreach($items as $item)
                            <a href="{{ $item['url'] }}" 
                               class="block p-3 border border-gray-200 rounded-lg hover:bg-green-50 hover:border-green-300 transition-colors">
                                <div class="font-medium text-gray-800">{{ $item['title'] }}</div>
                                <div class="text-sm text-gray-500 mt-1 flex justify-between">
                                    <span>{{ $item['url'] }}</span>
                                    <span class="text-xs bg-gray-100 px-2 py-1 rounded">
                                        {{ \Carbon\Carbon::parse($item['lastmod'])->format('M d, Y') }}
                                    </span>
                                </div>
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif
        @endforeach
    </div>
    @endif

    <!-- XML Sitemap -->
    @if($sitemapType === 'xml')
    <div class="bg-white rounded-lg shadow-md">
        <div class="border-b p-4 flex justify-between items-center">
            <h2 class="text-2xl font-bold text-gray-800">XML Sitemap</h2>
            <button onclick="copyXmlToClipboard()" 
                    class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm">
                📋 Copy XML
            </button>
        </div>
        
        <pre class="p-6 bg-gray-900 text-green-400 overflow-x-auto text-sm rounded-b-lg max-h-96 overflow-y-auto"><code class="xml">{!! htmlspecialchars('<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
' . collect($urls)->map(function($url) {
    return "  <url>
    <loc>" . htmlspecialchars($url['url']) . "</loc>
    <lastmod>{$url['lastmod']}</lastmod>
    <changefreq>{$url['changefreq']}</changefreq>
    <priority>{$url['priority']}</priority>
  </url>";
})->implode("\n") . '
</urlset>') !!}</code></pre>
    </div>
    @endif
</div>

<script>
function copyXmlToClipboard() {
    const xmlContent = `<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
@foreach($urls as $url)
    <url>
        <loc>{{ $url['url'] }}</loc>
        <lastmod>{{ $url['lastmod'] }}</lastmod>
        <changefreq>{{ $url['changefreq'] }}</changefreq>
        <priority>{{ $url['priority'] }}</priority>
    </url>
@endforeach
</urlset>`;
    
    navigator.clipboard.writeText(xmlContent).then(function() {
        alert('XML sitemap copied to clipboard!');
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}
</script>

<style>
.xml {
    font-family: 'Courier New', monospace;
    line-height: 1.4;
}
</style>
</div>
