 @section('meta-content')
@php
    $settings = \App\Models\Setting::find(1);
@endphp
    @if($settings)<title>{{$settings->site_title}}</title>@endif
    <meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
    <meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
    <meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
    <meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
 <div class="min-h-screen">
     <style>
        @keyframes fadeInUp {
            0% { 
                opacity: 0; 
                transform: translateY(30px); 
            }
            100% { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        @keyframes pulse {
            0%, 100% { 
                transform: scale(1); 
            }
            50% { 
                transform: scale(1.05); 
            }
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 0.8s ease-out forwards;
            opacity: 0;
        }
        
        .animate-pulse-slow {
            animation: pulse 4s ease-in-out infinite;
        }
        
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        
        .gradient-border {
            position: relative;
            background: linear-gradient(white, white) padding-box,
                        linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(168, 85, 247, 0.1)) border-box;
            border: 1px solid transparent;
        }
        
        .text-gradient {
            background: linear-gradient(135deg, #1E293B, #4F46E5);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .bg-premium-gradient {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .form-input {
            transition: all 0.3s ease;
        }
        
        .form-input:focus {
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
        }
        
        .file-upload-area {
            border: 2px dashed #d1d5db;
            transition: all 0.3s ease;
        }
        
        .file-upload-area:hover {
            border-color: #4f46e5;
            background-color: #f8fafc;
        }
        
        .step-indicator {
            position: relative;
        }
        
        .step-indicator:not(:last-child):after {
            content: '';
            position: absolute;
            top: 50%;
            right: -2rem;
            width: 4rem;
            height: 2px;
            background: #e5e7eb;
            transform: translateY(-50%);
        }
        
        .step-indicator.active:after {
            background: #4f46e5;
        }
    </style>
        <!-- Breadcrumb Navigation -->
        <div class="bg-white shadow-sm">
            <div class="container mx-auto px-6 py-4">
                <nav class="text-gray-600 text-sm">
                    <ul class="flex items-center space-x-2">
                        <li><a href="/" class="text-blue-500 hover:underline transition-colors">Home</a></li>
                        <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                        <li class="text-gray-500">Wholesale Account Application</li>
                    </ul>
                </nav>
            </div>
        </div>

        <!-- Wholesale Account Application Section -->
        <section class="container mx-auto px-6 py-12">
            <!-- Header Section -->
            <div class="text-center mb-12 animate-fadeInUp">
                <div class="flex items-center justify-center mb-6">
                    <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                        Wholesale <span class="text-gradient">Account Application</span>
                    </h2>
                </div>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    Join our exclusive network of wholesale partners and unlock premium pricing
                </p>
            </div>
            
            

            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                    <!-- Main Form -->
                    <div class="lg:col-span-2">
                        <div class="gradient-border bg-white rounded-2xl shadow-lg overflow-hidden animate-fadeInUp delay-200">
                            <!-- Form Header -->
                            <div class="bg-premium-gradient text-white p-6">
                                <h3 class="text-2xl font-bold flex items-center">
                                    <i class="fas fa-id-card mr-3"></i>
                                    Business Information
                                </h3>
                                <p class="text-indigo-100 mt-2">Please provide accurate business details for verification</p>
                            </div>
                            
                            <div class="p-8">
                                <!-- Success/Error Messages -->
                                <div>
                                    @if (session()->has('success'))
                                        <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-6 rounded-lg shadow-sm animate-fadeInUp">
                                            <div class="flex items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="fas fa-check-circle text-green-500 text-xl"></i>
                                                </div>
                                                <div class="ml-3">
                                                    <p class="text-green-700 font-medium">{{ session('success') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    @if (session()->has('error'))
                                        <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6 rounded-lg shadow-sm animate-fadeInUp">
                                            <div class="flex items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="fas fa-exclamation-circle text-red-500 text-xl"></i>
                                                </div>
                                                <div class="ml-3">
                                                    <p class="text-red-700 font-medium">{{ session('error') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>

                                <form wire:submit="store" class="space-y-6" enctype="multipart/form-data">
                                    <input type="hidden" name="source" wire:model="source">
                                    
                                    <!-- Personal Information Section -->
                                    <div class="border-b border-gray-200 pb-6">
                                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                            <i class="fas fa-user text-indigo-600 mr-2"></i>
                                            Personal Information
                                        </h4>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <!-- Firstname -->
                                            <div>
                                                <label for="firstname" class="block text-gray-700 font-medium mb-2">First Name</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="firstname" 
                                                           id="firstname" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('firstname') border-red-500 @enderror" 
                                                           placeholder="Enter First Name">
                                                    @error('firstname')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('firstname')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- Lastname -->
                                            <div>
                                                <label for="lastname" class="block text-gray-700 font-medium mb-2">Last Name</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="lastname" 
                                                           id="lastname" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('lastname') border-red-500 @enderror" 
                                                           placeholder="Enter Last Name">
                                                    @error('lastname')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('lastname')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Business Information Section -->
                                    <div class="border-b border-gray-200 pb-6">
                                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                            <i class="fas fa-building text-indigo-600 mr-2"></i>
                                            Business Information
                                        </h4>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <!-- Company Name -->
                                            <div>
                                                <label for="companyname" class="block text-gray-700 font-medium mb-2">Company Name</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="companyname" 
                                                           id="companyname" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('companyname') border-red-500 @enderror" 
                                                           placeholder="Enter Company Name">
                                                    @error('companyname')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('companyname')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- Employee ID -->
                                            <div>
                                                <label for="employeeid" class="block text-gray-700 font-medium mb-2">Employee ID</label>
                                                <div class="relative">
                                                    <input type="number" 
                                                           wire:model="employeeid" 
                                                           id="employeeid" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('employeeid') border-red-500 @enderror" 
                                                           placeholder="Enter Employee ID">
                                                    @error('employeeid')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('employeeid')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Contact Information Section -->
                                    <div class="border-b border-gray-200 pb-6">
                                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                            <i class="fas fa-address-card text-indigo-600 mr-2"></i>
                                            Contact Information
                                        </h4>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <!-- Email -->
                                            <div>
                                                <label for="email" class="block text-gray-700 font-medium mb-2">Email Address</label>
                                                <div class="relative">
                                                    <input type="email" 
                                                           wire:model="email" 
                                                           id="email" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('email') border-red-500 @enderror" 
                                                           placeholder="Enter Email Address">
                                                    @error('email')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('email')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- Phone -->
                                            <div>
                                                <label for="phone" class="block text-gray-700 font-medium mb-2">Phone Number</label>
                                                <div class="relative">
                                                    <input type="number" 
                                                           wire:model="phone" 
                                                           id="phone" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('phone') border-red-500 @enderror" 
                                                           placeholder="Enter Phone Number">
                                                    @error('phone')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('phone')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Address Information Section -->
                                    <div class="border-b border-gray-200 pb-6">
                                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                            <i class="fas fa-map-marker-alt text-indigo-600 mr-2"></i>
                                            Address Information
                                        </h4>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <!-- Address Primary -->
                                            <div>
                                                <label for="address_primary" class="block text-gray-700 font-medium mb-2">Primary Address</label>
                                                <input type="text" 
                                                       wire:model="address_primary" 
                                                       id="address_primary" 
                                                       class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('address_primary') border-red-500 @enderror" 
                                                       placeholder="Enter Primary Address">
                                                @error('address_primary')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- Address Secondary -->
                                            <div>
                                                <label for="address_secondary" class="block text-gray-700 font-medium mb-2">Secondary Address</label>
                                                <input type="text" 
                                                       wire:model="address_secondary" 
                                                       id="address_secondary" 
                                                       class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500" 
                                                       placeholder="Enter Secondary Address (Optional)">
                                            </div>

                                            <!-- Country -->
                                            <div>
                                                <label for="country" class="block text-gray-700 font-medium mb-2">Country</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="country" 
                                                           id="country" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('country') border-red-500 @enderror" 
                                                           placeholder="Enter Country">
                                                    @error('country')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('country')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- State -->
                                            <div>
                                                <label for="state" class="block text-gray-700 font-medium mb-2">State</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="state" 
                                                           id="state" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('state') border-red-500 @enderror" 
                                                           placeholder="Enter State">
                                                    @error('state')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('state')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- City -->
                                            <div>
                                                <label for="city" class="block text-gray-700 font-medium mb-2">City</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="city" 
                                                           id="city" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('city') border-red-500 @enderror" 
                                                           placeholder="Enter City">
                                                    @error('city')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('city')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Business Details Section -->
                                    <div class="border-b border-gray-200 pb-6">
                                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                            <i class="fas fa-chart-line text-indigo-600 mr-2"></i>
                                            Business Details
                                        </h4>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <!-- Seller Permit -->
                                            <div>
                                                <label for="seller_permit" class="block text-gray-700 font-medium mb-2">Seller Permit Number</label>
                                                <div class="relative">
                                                    <input type="number" 
                                                           wire:model="seller_permit" 
                                                           id="seller_permit" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('seller_permit') border-red-500 @enderror" 
                                                           placeholder="Seller's Permit / Reseller Certificate">
                                                    @error('seller_permit')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('seller_permit')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- Period -->
                                            <div>
                                                <label for="period" class="block text-gray-700 font-medium mb-2">Years in Business</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="period" 
                                                           id="period" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('period') border-red-500 @enderror" 
                                                           placeholder="How long have you been in this business?">
                                                    @error('period')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('period')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- Location -->
                                            <div>
                                                <label for="location" class="block text-gray-700 font-medium mb-2">Sales Channels</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="location" 
                                                           id="location" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('location') border-red-500 @enderror" 
                                                           placeholder="Where do you sell? (e.g., Online, Retail Store)">
                                                    @error('location')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('location')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>

                                            <!-- Reference -->
                                            <div>
                                                <label for="reference" class="block text-gray-700 font-medium mb-2">How did you hear about us?</label>
                                                <div class="relative">
                                                    <input type="text" 
                                                           wire:model="reference" 
                                                           id="reference" 
                                                           class="w-full p-3 border border-gray-300 rounded-lg form-input focus:border-indigo-500 @error('reference') border-red-500 @enderror" 
                                                           placeholder="How did you hear about us?">
                                                    @error('reference')
                                                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                            <i class="fas fa-exclamation-circle text-red-500"></i>
                                                        </div>
                                                    @enderror
                                                </div>
                                                @error('reference')
                                                    <p class="text-red-600 text-sm mt-1 flex items-center">
                                                        <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                    </p>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Document Upload Section -->
                                    <div class="pb-6">
                                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                            <i class="fas fa-file-upload text-indigo-600 mr-2"></i>
                                            Document Upload
                                        </h4>
                                        
                                        <!-- Permit Document -->
                                        <div class="w-full">
                                            <label for="permit_doc" class="block text-gray-700 font-medium mb-2">Upload Seller's Permit or Reseller Certificate</label>
                                            <div class="file-upload-area rounded-lg p-6 text-center cursor-pointer" onclick="document.getElementById('permit_doc').click()">
                                                <input type="file" 
                                                       wire:model="permit_doc" 
                                                       id="permit_doc" 
                                                       class="sr-only">
                                                <div class="flex flex-col items-center justify-center">
                                                    <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-3"></i>
                                                    <p class="text-gray-600 font-medium mb-1">
                                                        <span wire:loading.remove wire:target="permit_doc">
                                                            @if($permit_doc)
                                                                {{ $permit_doc->getClientOriginalName() }}
                                                            @else
                                                                Click to upload your document
                                                            @endif
                                                        </span>
                                                        <span wire:loading wire:target="permit_doc" class="flex items-center">
                                                            <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-indigo-500 mr-2"></div>
                                                            Uploading...
                                                        </span>
                                                    </p>
                                                    <p class="text-gray-500 text-sm">PDF, JPG, or PNG (Max 5MB)</p>
                                                </div>
                                            </div>
                                            @error('permit_doc')
                                                <p class="text-red-600 text-sm mt-1 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                                                </p>
                                            @enderror
                                            
                                            @if($permit_doc)
                                                <div class="mt-3 text-sm text-green-600 flex items-center bg-green-50 p-3 rounded-lg">
                                                    <i class="fas fa-check-circle mr-2"></i>
                                                    File selected: {{ $permit_doc->getClientOriginalName() }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- Submit Button -->
                                    <div class="pt-4">
                                        <button type="submit" 
                                                wire:loading.attr="disabled"
                                                class="w-full bg-gradient-to-r from-indigo-600 to-purple-600 text-white py-4 rounded-lg hover:from-indigo-700 hover:to-purple-700 transition-all duration-300 flex items-center justify-center disabled:opacity-50 disabled:cursor-not-allowed shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                                            <span wire:loading.remove wire:target="store" class="flex items-center">
                                                <i class="fas fa-paper-plane mr-2"></i>
                                                Submit Wholesale Application
                                            </span>
                                            <span wire:loading wire:target="store" class="flex items-center">
                                                <div class="animate-spin rounded-full h-5 w-5 border-b-2 border-white mr-2"></div>
                                                Processing Your Application...
                                            </span>
                                        </button>
                                        <p class="text-center text-gray-500 text-sm mt-3">
                                            By submitting this form, you agree to our <a href="#" class="text-indigo-600 hover:underline">Terms & Conditions</a>
                                        </p>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Sidebar Information -->
                    <div class="lg:col-span-1">
                        <div class="sticky top-6 space-y-6">
                            <!-- Information Card -->
                            <div class="bg-white rounded-2xl shadow-lg p-6 gradient-border animate-fadeInUp delay-300">
                                <h3 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-info-circle text-indigo-600 mr-2"></i>
                                    Application Process
                                </h3>
                                <div class="space-y-4">
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 mt-1">
                                            <div class="w-6 h-6 rounded-full bg-indigo-100 flex items-center justify-center">
                                                <i class="fas fa-check text-indigo-600 text-xs"></i>
                                            </div>
                                        </div>
                                        <p class="ml-3 text-gray-700">Submit your application with required documents</p>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 mt-1">
                                            <div class="w-6 h-6 rounded-full bg-indigo-100 flex items-center justify-center">
                                                <i class="fas fa-check text-indigo-600 text-xs"></i>
                                            </div>
                                        </div>
                                        <p class="ml-3 text-gray-700">Our team reviews within 1-2 business days</p>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 mt-1">
                                            <div class="w-6 h-6 rounded-full bg-indigo-100 flex items-center justify-center">
                                                <i class="fas fa-check text-indigo-600 text-xs"></i>
                                            </div>
                                        </div>
                                        <p class="ml-3 text-gray-700">Get approved and access wholesale pricing</p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Contact Card -->
                            <div class="bg-gradient-to-br from-indigo-500 to-purple-600 rounded-2xl shadow-lg p-6 text-white animate-fadeInUp delay-300">
                                <h3 class="text-xl font-bold mb-4 flex items-center">
                                    <i class="fas fa-headset mr-2"></i>
                                    Need Help?
                                </h3>
                                <p class="mb-4">Our support team is here to assist you with the application process.</p>
                                <div class="space-y-2">
                                    <div class="flex items-center">
                                        <i class="fas fa-envelope mr-3"></i>
                                        <span>sales@premierproductscous.com</span>
                                    </div>
                                    <div class="flex items-center">
                                        <i class="fas fa-phone mr-3"></i>
                                        <span>+1 (555) 123-4567</span>
                                    </div>
                                </div>
                                <button class="w-full mt-4 bg-white text-indigo-600 py-2 rounded-lg font-semibold hover:bg-gray-100 transition-colors">
                                    Contact Support
                                </button>
                            </div>
                            
                            <!-- Benefits Card -->
                            <div class="bg-white rounded-2xl shadow-lg p-6 gradient-border animate-fadeInUp delay-300">
                                <h3 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-star text-yellow-500 mr-2"></i>
                                    Wholesale Benefits
                                </h3>
                                <ul class="space-y-3">
                                    <li class="flex items-start">
                                        <i class="fas fa-check text-green-500 mr-2 mt-1"></i>
                                        <span>Exclusive pricing on all products</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check text-green-500 mr-2 mt-1"></i>
                                        <span>Priority customer support</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check text-green-500 mr-2 mt-1"></i>
                                        <span>Early access to new products</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check text-green-500 mr-2 mt-1"></i>
                                        <span>Volume discounts and special offers</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>