<div>
    <div class="max-w-7xl mx-auto px-4">
        <!-- Breadcrumb -->
        <nav class="flex mb-8" aria-label="Breadcrumb">
            <ol class="flex items-center space-x-2 text-sm text-gray-500">
                <li>
                    <a href="/" class="hover:text-blue-600 transition-colors">Home</a>
                </li>
                <li class="flex items-center">
                    <svg class="w-4 h-4 mx-1" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                    </svg>
                    <a href="/blog" class="hover:text-blue-600 transition-colors">Topics</a>
                </li>
                <li class="flex items-center">
                    <svg class="w-4 h-4 mx-1" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                    </svg>
                    <span class="text-gray-900 font-medium">{{ $category->name ?? 'Uncategorized' }}</span>
                </li>
                <li class="flex items-center">
                    <svg class="w-4 h-4 mx-1" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                    </svg>
                    <span class="text-gray-900 font-medium">{{ $subcategory->name ?? 'Uncategorized' }}</span>
                </li>
            </ol>
        </nav>
    <section class="">
        <h1 class="text-2xl font-bold text-gray-900 mb-6 border-l-4 border-blue-600 pl-4">{{$subcategory->name}}</h1>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($blogsbysubcategories as $post)
            <a href="{{route('user.blog.detail',$post->slug)}}" wire:navigate>
                <article class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group">
                <div class="relative overflow-hidden">
                    <img src="{{asset('storage/' .$post->image)}}" 
                            alt="Related post" 
                            class="w-full h-48 object-cover transform transition-transform duration-500 group-hover:scale-110">
                    <div class="absolute top-4 left-4">
                        <span class="bg-blue-600 text-white px-3 py-1 text-xs font-bold rounded-full shadow-lg">{{ $post->category->name }}</span>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="font-bold text-lg text-gray-900 mb-3 group-hover:text-blue-600 transition-colors line-clamp-2">
                        {{ $post->name }}
                    </h3>
                    
                    <div class="flex items-center justify-between text-sm text-gray-500">
                        <span>By Author</span>
                        <span>{{ \Carbon\Carbon::parse($post->created_at)->diffForHumans() }}</span>
                    </div>
                </div>
            </article>
            </a>
            @endforeach
        </div>
    </section>
    </div>
</div>
