<div>
     <!-- Breadcrumb Navigation -->
    <div class="container mx-auto px-6 py-4">
        <nav class="text-gray-600 text-sm">
            <ul class="flex items-center space-x-2">
                <li><a href="/" class="text-blue-500 hover:underline">Home</a></li>
                <li><i class="fa fa-angle-right"></i></li>
                <li class="text-gray-500">All Brands</li>
            </ul>
        </nav>
    </div>
 <!-- Categories Section -->
    <section class="container mx-auto px-6 py-10">
        <h2 class="text-3xl font-bold text-center text-gray-800 mb-8">Brands</h2>
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($brands as $brand)
            <div class="bg-white shadow-md rounded-lg p-4 flex flex-col items-center hover:shadow-lg transition">
                 <picture>
                        <source srcset="{{ Storage::url($brand->image) }}" type="image/webp" class="w-20 h-20 object-cover mb-4">
                        <img src="{{ Storage::url($brand->image) }}" alt="{{$brand->name}}" class="w-20 h-20 object-cover mb-4">
                    </picture>
               
                <h3 class="text-lg font-semibold">{{$brand->name}}</h3>
            </div>
            @endforeach
           
        </div>
    </section>
</div>
