@section('meta-content')
@php
    $settings = \App\Models\Setting::find(1);
@endphp
    @if($settings)<title>{{$settings->site_title}}</title>@endif
    <meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
    <meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
    <meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
    <meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
<div>
   <!-- Breadcrumb Navigation -->
    <div class="container mx-auto px-6 py-4">
        <nav class="text-gray-600 text-sm">
            <ul class="flex items-center space-x-2">
                <li><a href="/" class="text-blue-500 hover:underline">Home</a></li>
                <li><i class="fa fa-angle-right"></i></li>
                <li class="text-gray-500">All Categories</li>
            </ul>
        </nav>
    </div>
 <!-- Categories Section -->
    <section class="container mx-auto px-6 py-10">
        <h2 class="text-3xl font-bold text-center text-gray-800 mb-8">Categories</h2>
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($categories as $category)
            <div class="bg-white shadow-md rounded-lg p-4 flex flex-col items-center hover:shadow-lg transition">
                 <picture>
                        <source srcset="{{asset('storage/' .$category->image) }}" type="image/webp" class="w-20 h-20 object-cover mb-4">
                        <img src="{{asset('storage/' .$category->image) }}" alt="{{$category->name}}" class="w-20 h-20 object-cover mb-4">
                    </picture>
               
                <h3 class="text-lg font-semibold">{{$category->name}}</h3>
                <a href="{{route('user.products.by-category', $category->slug)}}" wire:navigate class="text-blue-500 mt-2">View Products</a>
            </div>
            @endforeach
           
        </div>
    </section>
</div>
