@section('meta-content')
@php
    $settings = \App\Models\Setting::find(1);
    $page_metas = \App\Models\PageMeta::find(1);
@endphp
    @if($page_metas)<title>{{$page_metas->home_title}}</title>@endif
    <meta name="title" content="@if($page_metas){{$page_metas->home_meta_title}}@endif">
    <meta name="description" content="@if($page_metas){{$page_metas->home_meta_description}}@endif">
    <meta name="tags" content="@if($page_metas){{$page_metas->home_meta_tags}}@endif">
    <meta name="keywords" content="@if($page_metas){{$page_metas->home_meta_keywords}}@endif">
    @if($page_metas)<script>{!!$page_metas->home_page_schema!!}</script>@endif
@endsection
<div>
    <!-- ✅ Hero Section -->
 <section class="relative w-full h-screen flex items-center justify-center text-center text-white overflow-hidden">
    <style>
        @keyframes fadeInUp {
            0% { 
                opacity: 0; 
                transform: translateY(40px); 
            }
            100% { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        @keyframes fadeIn {
            0% { 
                opacity: 0; 
            }
            100% { 
                opacity: 1; 
            }
        }
        
        @keyframes pulse {
            0%, 100% { 
                transform: scale(1); 
            }
            50% { 
                transform: scale(1.05); 
            }
        }
        
        @keyframes float {
            0%, 100% { 
                transform: translateY(0); 
            }
            50% { 
                transform: translateY(-10px); 
            }
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 1s ease-out forwards;
            opacity: 0;
        }
        
        .animate-fadeIn {
            animation: fadeIn 1.5s ease-out forwards;
            opacity: 0;
        }
        
        .animate-pulse-slow {
            animation: pulse 4s ease-in-out infinite;
        }
        
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        
        .gradient-overlay {
            background: linear-gradient(135deg, rgba(35, 47, 62, 0.85) 0%, rgba(0, 0, 0, 0.7) 100%);
        }
        
        .text-gradient {
            background: linear-gradient(135deg, #F59E0B, #FBBF24);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .hero-bg {
            background-image: url('https://images.unsplash.com/photo-1556742049-0cfed4f6a45d?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80');
            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;
        }
    </style>
        <!-- Background Image with Parallax Effect -->
        <div class="hero-bg absolute inset-0 bg-fixed"></div>
        
        <!-- Gradient Overlay -->
        <div class="absolute inset-0 gradient-overlay"></div>
        
        <!-- Animated Background Elements -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <!-- Floating elements -->
            <div class="absolute top-1/4 left-1/4 w-20 h-20 bg-yellow-400/10 rounded-full animate-float"></div>
            <div class="absolute top-1/3 right-1/4 w-16 h-16 bg-yellow-400/10 rounded-full animate-float" style="animation-delay: 1s;"></div>
            <div class="absolute bottom-1/4 left-1/3 w-24 h-24 bg-yellow-400/10 rounded-full animate-float" style="animation-delay: 2s;"></div>
            
            <!-- Grid pattern overlay -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute inset-0" style="background-image: linear-gradient(to right, rgba(255,255,255,0.1) 1px, transparent 1px), linear-gradient(to bottom, rgba(255,255,255,0.1) 1px, transparent 1px); background-size: 50px 50px;"></div>
            </div>
        </div>

        <!-- Content Container -->
        <div class="relative z-10 px-4 w-full max-w-5xl">
            <!-- Badge -->
            <div class="inline-flex items-center bg-white/10 backdrop-blur-sm rounded-full px-4 py-2 mb-8 animate-fadeIn">
                <span class="w-2 h-2 bg-yellow-400 rounded-full mr-2 animate-pulse-slow"></span>
                <span class="text-sm font-medium">Top Amazon FBA Wholesale Suppliers</span>
            </div>
            
            <!-- Main Heading -->
            <h1 class="text-3xl md:text-3xl lg:text-5xl font-bold mb-6 animate-fadeInUp" style="font-family: 'Merriweather', serif;">
                Premium Wholesale 
                <span class="text-gradient block mt-2">Amazon Products</span>
            </h1>
            
            <!-- Subtitle -->
            <p class="text-xl md:text-2xl text-gray-200 mb-10 max-w-3xl mx-auto leading-relaxed animate-fadeInUp" style="animation-delay: 0.3s;">
                Source top-selling Amazon FBA products from trusted wholesale suppliers in the USA.


            </p>
            
            <!-- CTA Buttons -->
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4 mb-12 animate-fadeInUp" style="animation-delay: 0.6s;">
                <a href="{{route('user.apply-wholesale')}}" wire:navigate class="inline-flex items-center bg-gradient-to-r from-yellow-500 to-yellow-600 hover:from-yellow-600 hover:to-yellow-700 text-gray-900 font-bold py-4 px-10 rounded-full shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
                    <span>Apply for Wholesale</span>
                    <svg class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                    </svg>
                </a>
                
                <a href="{{route('user.about')}}"  wire:navigate class="inline-flex items-center bg-transparent hover:bg-white/10 text-white font-semibold py-4 px-8 rounded-full border border-white/30 hover:border-white/50 transition-all duration-300 backdrop-blur-sm">
                    <span>Learn More About Us</span>
                </a>
            </div>
            
            <!-- Trust Indicators -->
            <div class="flex flex-wrap items-center justify-center gap-8 text-gray-300 animate-fadeIn" style="animation-delay: 0.9s;">
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-yellow-400 mr-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                    </svg>
                    <span>On-Time Delivery</span>
                </div>
                
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-yellow-400 mr-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"></path>
                    </svg>
                    <span>High-Demand Products </span>
                </div>
                
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-yellow-400 mr-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <span>Competitive Pricing</span>
                </div>
            </div>
        </div>
        
        
    </section>
<section class="py-20 overflow-hidden relative">
    <style>
        @keyframes slide-in-left {
            0% { transform: translateX(-100px); opacity: 0; }
            100% { transform: translateX(0); opacity: 1; }
        }
        @keyframes slide-in-right {
            0% { transform: translateX(100px); opacity: 0; }
            100% { transform: translateX(0); opacity: 1; }
        }
        @keyframes slide-in-up {
            0% { transform: translateY(50px); opacity: 0; }
            100% { transform: translateY(0); opacity: 1; }
        }
        @keyframes pulse-glow {
            0%, 100% { box-shadow: 0 0 20px rgba(99, 102, 241, 0.3); }
            50% { box-shadow: 0 0 30px rgba(99, 102, 241, 0.6); }
        }

        .animate-slide-in-left {
            animation: slide-in-left 0.8s ease-out forwards;
        }
        .animate-slide-in-right {
            animation: slide-in-right 0.8s ease-out forwards;
        }
        .animate-slide-in-up {
            animation: slide-in-up 0.8s ease-out forwards;
        }
        .animate-pulse-glow {
            animation: pulse-glow 3s ease-in-out infinite;
        }

        .delay-200 { animation-delay: 0.2s; }
        .delay-400 { animation-delay: 0.4s; }
        .delay-600 { animation-delay: 0.6s; }

        .glass-effect {
            backdrop-filter: blur(16px);
            background: rgba(255, 255, 255, 0.7);
        }
        
        .gradient-border {
            position: relative;
            background: linear-gradient(white, white) padding-box,
                        linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(168, 85, 247, 0.2)) border-box;
            border: 1px solid transparent;
        }
        
        .text-gradient {
            background: linear-gradient(135deg, #4F46E5, #7E22CE);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
        <!-- Background Elements -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-blue-900/5 rounded-full"></div>
            <div class="absolute -bottom-32 -left-32 w-80 h-80 bg-yellow-500/5 rounded-full"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl h-64 bg-gradient-to-r from-blue-900/5 to-yellow-500/5 blur-3xl rounded-full"></div>
            
            <!-- Grid Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute inset-0" style="background-image: linear-gradient(to right, gray 1px, transparent 1px), linear-gradient(to bottom, gray 1px, transparent 1px); background-size: 50px 50px;"></div>
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <!-- Section Header -->
            <div class="text-center mb-16">
                <div class="inline-flex items-center justify-center mb-6 animate-slide-in-up">
                    <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                        Why Choose <span class="text-gradient">Min Mazx Solution</span>
                    </h2>
                </div>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto animate-slide-in-up delay-200">
                    Unlock the Perks of Working with Verified Amazon Wholesale Suppliers
                </p>
            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Card 1 -->
                

                <!-- Card 2 -->
                <div class="group relative">
                    <div class="absolute -inset-0.5 bg-gradient-to-r from-[#232F3E] to-yellow-500 rounded-2xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200"></div>
                    <div class="relative glass-effect gradient-border rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-500 group-hover:-translate-y-2 animate-slide-in-up delay-200">
                        <div class="w-20 h-20 mx-auto mb-6 rounded-full bg-gradient-to-br from-[#232F3E] to-yellow-500 flex items-center justify-center text-white text-3xl shadow-lg animate-pulse-glow" style="animation-delay: 0.5s;">
                            <i class="fas fa-user-shield"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-center mb-4 text-gray-800">Top Selling Products</h3>
                        <p class="text-gray-700 text-center leading-relaxed">
                            Explore our top-selling Amazon FBA products sourced from trusted wholesale suppliers in the USA. Each product is carefully selected to maximize your sales and profit potential. Start sourcing high-demand items for your Amazon FBA business today.

                        </p>
                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <ul class="text-gray-600 space-y-2 text-sm">
                                <li class="flex items-center">
                                    <i class="fas fa-check text-yellow-500 mr-2"></i>
                                    <span>Vetted and verified suppliers</span>
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-yellow-500 mr-2"></i>
                                    <span>Quality assurance guarantee</span>
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-yellow-500 mr-2"></i>
                                    <span>Consistent product availability</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Card 3 -->
                <div class="group relative">
                    <div class="absolute -inset-0.5 bg-gradient-to-r from-green-400 to-green-600 rounded-2xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200"></div>
                    <div class="relative glass-effect gradient-border rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-500 group-hover:-translate-y-2 animate-slide-in-right delay-400">
                        <div class="w-20 h-20 mx-auto mb-6 rounded-full bg-gradient-to-br from-green-400 to-green-600 flex items-center justify-center text-white text-3xl shadow-lg animate-pulse-glow" style="animation-delay: 1s;">
                            <i class="fas fa-shipping-fast"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-center mb-4 text-green-700">Pre-Vetted Inventory</h3>
                        <p class="text-gray-700 text-center leading-relaxed">
                            Our pre-vetted inventory ensures you get high quality products from trusted Amazon FBA wholesale suppliers in the USA. Each item is carefully verified to meet Amazon standards, helping you source reliably and boost your FBA business.
                        </p>
                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <ul class="text-gray-600 space-y-2 text-sm">
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    <span>Expedited shipping options</span>
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    <span>Real-time tracking</span>
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    <span>Global delivery network</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="group relative">
                    <div class="absolute -inset-0.5 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-2xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200"></div>
                    <div class="relative glass-effect gradient-border rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-500 group-hover:-translate-y-2 animate-slide-in-left">
                        <div class="w-20 h-20 mx-auto mb-6 rounded-full bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center text-white text-3xl shadow-lg animate-pulse-glow">
                            <i class="fas fa-boxes"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-center mb-4 text-indigo-700">Fast Shipping</h3>
                        <p class="text-gray-700 text-center leading-relaxed">
                           MinMaxSolutionsLLC offers fast, dependable shipping for Amazon FBA products from trusted suppliers in the USA. Keep your store stocked and profits growing without delays.

                        </p>
                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <ul class="text-gray-600 space-y-2 text-sm">
                                <li class="flex items-center">
                                    <i class="fas fa-check text-indigo-500 mr-2"></i>
                                    <span>Thousands of verified products</span>
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-indigo-500 mr-2"></i>
                                    <span>Competitive wholesale pricing</span>
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-indigo-500 mr-2"></i>
                                    <span>Curated quality selection</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom CTA -->
            <div class="mt-16 text-center animate-slide-in-up delay-600">
                <div class="inline-flex flex-col sm:flex-row items-center justify-center space-y-4 sm:space-y-0 sm:space-x-6 bg-white/80 backdrop-blur-sm rounded-2xl p-6 shadow-lg border border-gray-200 max-w-2xl mx-auto">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-br from-indigo-500 to-purple-500 flex items-center justify-center shadow-md">
                            <i class="fas fa-rocket text-white"></i>
                        </div>
                        <div class="text-left">
                            <p class="font-bold text-gray-800">Fast Shipping</p>
                            <p class="text-gray-600 text-sm">Join thousands of satisfied businesses today</p>
                        </div>
                    </div>
                    <a href="{{route('user.apply-wholesale')}}" wire:navigate class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-semibold rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 hover:scale-105">
                        Get Started Now
                    </a>
                </div>
            </div>
        </div>
    </section>


<!-- ================= TWO COLUMN SECTION ================= -->
<section class="relative py-20 overflow-hidden bg-gradient-to-b from-gray-100 via-white to-gray-50">
  <!-- Decorative Background Blobs -->
  <div class="absolute top-0 left-0 w-72 h-72 bg-blue-100 rounded-full blur-3xl opacity-40 -z-10"></div>
  <div class="absolute bottom-0 right-0 w-96 h-96 bg-green-100 rounded-full blur-3xl opacity-40 -z-10"></div>

 <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <!-- Section Heading -->
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center mb-6 animate-slide-in-left">
                <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather', serif;">
                    Why <span class="text-gradient">Amazon FBA Sellers </span> Choose <span class="text-gradient">MinMaxSolutionsLLC</span> 
                </h2>
            </div>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto animate-fade-in-up">
               Discover the benefits of partnering with MinMaxSolutionsLLC and why Amazon FBA sellers trust us for top-quality wholesale products, fast shipping, and reliable sourcing in the USA.

            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
            <!-- Left Content - Mission -->
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-indigo-600 to-blue-400 rounded-2xl blur opacity-25 group-hover:opacity-75 transition duration-1000 group-hover:duration-200"></div>
                <div class="relative gradient-border rounded-2xl p-10 shadow-xl hover:shadow-2xl transition-all duration-500 group-hover:-translate-y-2 animate-slide-in-left">
                    <div class="absolute -top-6 -left-6 bg-gradient-to-br from-indigo-600 to-blue-400 text-white p-5 rounded-xl shadow-lg z-10">
                        <i class="fas fa-bullseye text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-6 text-indigo-700 pt-2" style="font-family: 'Merriweather', serif;">Our Mission</h3>
                    <p class="text-gray-700 leading-relaxed text-lg mb-6">
                        At <strong class="text-indigo-700">MinMaxSolutionLLC</strong>, we aim to simplify Amazon FBA sourcing by offering verified wholesale products and  helping sellers to grow with ease and confidence.

                    </p>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-indigo-100 flex items-center justify-center">
                                    <i class="fas fa-check text-indigo-600 text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-gray-700"><span class="font-medium text-indigo-600">Reliable Wholesale Inventory</span> - High-quality products ready for Amazon FBA.</p>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-indigo-100 flex items-center justify-center">
                                    <i class="fas fa-check text-indigo-600 text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-gray-700"><span class="font-medium text-indigo-600">Smart Sourcing Solutions</span> - Find the best products to maximize your profits.</p>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-indigo-100 flex items-center justify-center">
                                    <i class="fas fa-check text-indigo-600 text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-gray-700"><span class="font-medium text-indigo-600">Dependable Delivery</span> - Fast and secure shipping to keep your business running smoothly.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Content - Why Choose Us -->
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-green-500 to-teal-400 rounded-2xl blur opacity-25 group-hover:opacity-75 transition duration-1000 group-hover:duration-200"></div>
                <div class="relative gradient-border-green rounded-2xl p-10 shadow-xl hover:shadow-2xl transition-all duration-500 group-hover:-translate-y-2 animate-slide-in-right">
                    <div class="absolute -top-6 -left-6 bg-gradient-to-br from-green-500 to-teal-400 text-white p-5 rounded-xl shadow-lg z-10">
                        <i class="fas fa-handshake text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-6 text-green-700 pt-2" style="font-family: 'Merriweather', serif;">Our Motto</h3>
                    <p class="text-gray-700 leading-relaxed text-lg mb-6">
                        Helping Amazon FBA sellers succeed with quality wholesale products, streamlined sourcing, and dependable solutions for consistent growth.
                    </p>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-green-100 flex items-center justify-center">
                                    <i class="fas fa-shipping-fast text-green-600 text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-gray-700"><span class="font-medium text-green-600">Quality Assurance</span> - Only pre-vetted, high-standard products for Amazon FBA.</p>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-green-100 flex items-center justify-center">
                                    <i class="fas fa-chart-line text-green-600 text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-gray-700"><span class="font-medium text-green-600">Profit-Driven Selection</span> - Top-selling items to maximize your business revenue</p>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-green-100 flex items-center justify-center">
                                    <i class="fas fa-headset text-green-600 text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-gray-700"><span class="font-medium text-green-600">Dedicated Support</span> - Expert guidance for smooth sourcing and inventory management.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom CTA -->
        <div class="mt-16 text-center animate-fade-in-up">
            <div class="inline-flex items-center space-x-4 bg-white rounded-2xl p-6 shadow-lg border border-gray-100">
                <div class="w-12 h-12 rounded-full bg-gradient-to-br from-yellow-400 to-yellow-500 flex items-center justify-center shadow-md">
                    <i class="fas fa-star text-white"></i>
                </div>
                <div class="text-left">
                    <p class="font-semibold text-gray-800">Ready to transform your wholesale experience?</p>
                    <p class="text-gray-600 text-sm">Join thousands of satisfied businesses today</p>
                </div>
                <a href="{{route('user.apply-wholesale')}}" wire:navigate class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-blue-500 text-white font-semibold rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                    Get Started
                </a>
            </div>
        </div>
    </div>

  <!-- Animations -->
  <style>
        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .animate-slide-in-left {
            animation: slideInLeft 0.8s ease-out forwards;
        }
        .animate-slide-in-right {
            animation: slideInRight 0.8s ease-out forwards;
        }
        .animate-fade-in-up {
            animation: fadeInUp 0.8s ease-out forwards;
        }
        .glass-effect {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.8);
        }
        .gradient-border {
            position: relative;
            background: linear-gradient(white, white) padding-box,
                        linear-gradient(135deg, #4F46E5, #7E22CE) border-box;
            border: 1px solid transparent;
        }
        .gradient-border-green {
            position: relative;
            background: linear-gradient(white, white) padding-box,
                        linear-gradient(135deg, #10B981, #059669) border-box;
            border: 1px solid transparent;
        }
        .text-gradient {
            background: linear-gradient(135deg, #1E293B, #4F46E5);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
</section>

<section class="py-20 relative overflow-hidden">
    <style>
        @keyframes fadeInUp {
            0% { transform: translateY(30px); opacity: 0; }
            100% { transform: translateY(0); opacity: 1; }
        }
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        
        .animate-fade-in-up {
            animation: fadeInUp 0.8s ease-out forwards;
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        
        .delay-200 { animation-delay: 0.2s; }
        .delay-400 { animation-delay: 0.4s; }
        
        .gradient-overlay {
            background: linear-gradient(to top, rgba(0,0,0,0.85) 0%, rgba(0,0,0,0.5) 40%, transparent 100%);
        }
        
        .card-hover {
            transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        .card-hover:hover {
            transform: translateY(-10px) scale(1.02);
        }
        
        .image-placeholder-1 {
            background: linear-gradient(45deg, #4F46E5, #7E22CE);
        }
        
        .image-placeholder-2 {
            background: linear-gradient(45deg, #059669, #10B981);
        }
    </style>
        <!-- Background decorative elements -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-blue-900/5 rounded-full"></div>
            <div class="absolute -bottom-32 -left-32 w-80 h-80 bg-yellow-500/5 rounded-full"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl h-64 bg-gradient-to-r from-blue-900/5 to-yellow-500/5 blur-3xl rounded-full"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <!-- Section Heading -->
            <div class="text-center mb-16">
                <div class="inline-flex items-center justify-center mb-6 animate-fade-in-up">
                    <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                        Our <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-purple-600">Advantages</span>
                    </h2>
                </div>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto animate-fade-in-up delay-200">
                    Find out why thousands of Amazon FBA sellers choose MinMaxSolutionsLLC for high-quality wholesale products.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                <!-- Column 1: Extensive Product Range -->
                <div class="group relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-3xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl card-hover animate-fade-in-up">
                        <!-- Image with gradient overlay -->
                        <div class="relative h-96 overflow-hidden">
                            <!-- Background Image -->
                            <div class="absolute inset-0 bg-cover bg-center" style="background-image: url('https://images.unsplash.com/photo-1556742049-0cfed4f6a45d?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80')"></div>
                            
                            <div class="absolute inset-0 gradient-overlay flex items-end p-8">
                                <div class="transform transition-transform duration-500 group-hover:translate-y-0 translate-y-2">
                                    <div class="flex items-center mb-4">
                                        <div class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center text-white mr-3 backdrop-blur-sm">
                                            <i class="fas fa-boxes"></i>
                                        </div>
                                        <h3 class="text-3xl font-bold text-white">Extensive Product Range</h3>
                                    </div>
                                    <p class="text-gray-200 text-lg max-w-md">
                                       Access a wide variety of verified wholesale products for Amazon FBA, carefully selected to meet your business needs and boost sales.

                                    </p>
                                    <div class="mt-6 flex flex-wrap gap-2">
                                        <span class="px-3 py-1 bg-white/20 backdrop-blur-sm rounded-full text-white text-sm">Bulk Pricing</span>
                                        <span class="px-3 py-1 bg-white/20 backdrop-blur-sm rounded-full text-white text-sm">Curated Selection</span>
                                        <span class="px-3 py-1 bg-white/20 backdrop-blur-sm rounded-full text-white text-sm">High Demand</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Column 2: Trusted Suppliers -->
                <div class="group relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-amber-500 to-orange-500 rounded-3xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200 delay-200"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl card-hover animate-fade-in-up delay-200">
                        <!-- Image with gradient overlay -->
                        <div class="relative h-96 overflow-hidden">
                            <!-- Background Image -->
                            <div class="absolute inset-0 bg-cover bg-center" style="background-image: url('https://images.unsplash.com/photo-1560472354-b33ff0c44a43?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2069&q=80')"></div>
                            
                            <div class="absolute inset-0 gradient-overlay flex items-end p-8">
                                <div class="transform transition-transform duration-500 group-hover:translate-y-0 translate-y-2">
                                    <div class="flex items-center mb-4">
                                        <div class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center text-white mr-3 backdrop-blur-sm">
                                            <i class="fas fa-user-shield"></i>
                                        </div>
                                        <h3 class="text-3xl font-bold text-white">High-ROI Product Lines</h3>
                                    </div>
                                    <p class="text-gray-200 text-lg max-w-md">
                                       Unlock profitable, fast-moving wholesale products designed to maximize your Amazon FBA profits. Our hand-picked inventory focuses on high-demand categories, helping you scale your business with reliable, high-ROI opportunities.

                                    </p>
                                    <div class="mt-6 flex flex-wrap gap-2">
                                        <span class="px-3 py-1 bg-white/20 backdrop-blur-sm rounded-full text-white text-sm">Verified Partners</span>
                                        <span class="px-3 py-1 bg-white/20 backdrop-blur-sm rounded-full text-white text-sm">Quality Assured</span>
                                        <span class="px-3 py-1 bg-white/20 backdrop-blur-sm rounded-full text-white text-sm">Reliable Service</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Bottom CTA -->
            <div class="mt-16 text-center animate-fade-in-up delay-400">
                <div class="inline-flex flex-col sm:flex-row items-center justify-center space-y-4 sm:space-y-0 sm:space-x-6 bg-white/80 backdrop-blur-sm rounded-2xl p-6 shadow-lg border border-gray-200 max-w-2xl mx-auto">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-br from-indigo-500 to-purple-500 flex items-center justify-center shadow-md">
                            <i class="fas fa-rocket text-white"></i>
                        </div>
                        <div class="text-left">
                            <p class="font-bold text-gray-800">Ready to elevate your business?</p>
                            <p class="text-gray-600 text-sm">Join thousands of successful retailers</p>
                        </div>
                    </div>
                    <a href="{{route('user.apply-wholesale')}}" wire:navigate class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-semibold rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 hover:scale-105">
                        Get Started Today
                    </a>
                </div>
            </div>
        </div>
    </section>


   <section class="py-24 relative overflow-hidden">
    <style>
        @keyframes countUp {
            0% { transform: translateY(20px); opacity: 0; }
            100% { transform: translateY(0); opacity: 1; }
        }
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        .animate-count-up {
            animation: countUp 2s ease-out forwards;
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        .glass-effect {
            backdrop-filter: blur(16px) saturate(180%);
            background-color: rgba(255, 255, 255, 0.75);
            border: 1px solid rgba(255, 255, 255, 0.125);
        }
        .text-shadow {
            text-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
    </style>
        <!-- Background elements -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-blue-900/5 rounded-full"></div>
            <div class="absolute -bottom-32 -left-32 w-80 h-80 bg-yellow-500/5 rounded-full"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl h-64 bg-gradient-to-r from-blue-900/5 to-yellow-500/5 blur-3xl rounded-full"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <!-- Section Header -->
            <div class="text-center mb-16">
                <div class="inline-flex items-center justify-center mb-6">
                    <div class="w-3 h-12 bg-yellow-500 rounded-full mr-4 transform rotate-12"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">Our Achievements</h2>
                </div>
                <p class="text-xl text-gray-700 max-w-3xl mx-auto leading-relaxed">
                    Recognizing the key milestones that showcase our dedication to quality, trusted sourcing, and long-term success for Amazon FBA sellers.

                </p>
            </div>

            <!-- Stats Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                
                <!-- Stat 1 -->
                <div class="group relative">
                    <div class="absolute -inset-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-2xl blur opacity-25 group-hover:opacity-75 transition duration-1000 group-hover:duration-200"></div>
                    <div class="glass-effect relative rounded-2xl p-8 flex flex-col items-center shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-2">
                        <div class="w-20 h-20 rounded-full bg-gradient-to-br from-indigo-500 to-purple-500 flex items-center justify-center mb-6 shadow-lg animate-float">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                        </div>
                        <span class="text-5xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-indigo-600 to-purple-600 counter text-shadow" data-count="500">0</span>
                        <p class="mt-4 text-gray-700 text-lg font-medium text-center">500+ Happy Clients</p>
                        <div class="mt-4 w-12 h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-full"></div>
                    </div>
                </div>

                <!-- Stat 2 -->
                <div class="group relative">
                    <div class="absolute -inset-1 bg-gradient-to-r from-blue-900 to-orange-500 rounded-2xl blur opacity-25 group-hover:opacity-75 transition duration-1000 group-hover:duration-200"></div>
                    <div class="glass-effect relative rounded-2xl p-8 flex flex-col items-center shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-2">
                        <div class="w-20 h-20 rounded-full bg-gradient-to-br from-blue-900 to-orange-500 flex items-center justify-center mb-6 shadow-lg animate-float" style="animation-delay: 0.5s;">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4" />
                            </svg>
                        </div>
                        <span class="text-5xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-blue-900 to-orange-500 counter text-shadow" data-count="50">0</span>
                        <p class="mt-4 text-gray-700 text-lg font-medium text-center">50+ Brand Products Available</p>
                        <div class="mt-4 w-12 h-1 bg-gradient-to-r from-blue-900 to-orange-500 rounded-full"></div>
                    </div>
                </div>

                <!-- Stat 3 -->
                <div class="group relative">
                    <div class="absolute -inset-1 bg-gradient-to-r from-green-400 to-teal-500 rounded-2xl blur opacity-25 group-hover:opacity-75 transition duration-1000 group-hover:duration-200"></div>
                    <div class="glass-effect relative rounded-2xl p-8 flex flex-col items-center shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-2">
                        <div class="w-20 h-20 rounded-full bg-gradient-to-br from-green-400 to-teal-500 flex items-center justify-center mb-6 shadow-lg animate-float" style="animation-delay: 1s;">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.764a2 2 0 011.789 2.894l-3.5 7A2 2 0 0115.263 21h-4.017c-.163 0-.326-.02-.485-.06L7 20m7-10V5a2 2 0 00-2-2h-.095c-.5 0-.905.405-.905.905 0 .714-.211 1.412-.608 2.006L7 11v9m7-10h-2M7 20H5a2 2 0 01-2-2v-6a2 2 0 012-2h2.5" />
                            </svg>
                        </div>
                        <span class="text-5xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-green-400 to-teal-500 counter text-shadow" data-count="1000">0</span>
                        <p class="mt-4 text-gray-700 text-lg font-medium text-center">1000+ Successfull Orders Fulfiled</p>
                        <div class="mt-4 w-12 h-1 bg-gradient-to-r from-green-400 to-teal-500 rounded-full"></div>
                    </div>
                </div>

                <!-- Stat 4 -->
                <div class="group relative">
                    <div class="absolute -inset-1 bg-gradient-to-r from-pink-500 to-red-500 rounded-2xl blur opacity-25 group-hover:opacity-75 transition duration-1000 group-hover:duration-200"></div>
                    <div class="glass-effect relative rounded-2xl p-8 flex flex-col items-center shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-2">
                        <div class="w-20 h-20 rounded-full bg-gradient-to-br from-pink-500 to-red-500 flex items-center justify-center mb-6 shadow-lg animate-float" style="animation-delay: 1.5s;">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <span class="text-5xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-pink-500 to-red-500 counter text-shadow" data-count="5">0</span>
                        <p class="mt-4 text-gray-700 text-lg font-medium text-center">5+ Years of Experience</p>
                        <div class="mt-4 w-12 h-1 bg-gradient-to-r from-pink-500 to-red-500 rounded-full"></div>
                    </div>
                </div>

            </div>
            
            <!-- CTA Section -->
            <div class="mt-20 text-center">
                <p class="text-lg text-gray-600 mb-8">Join thousands of satisfied customers who trust our products</p>
                <a href="{{route('user.products')}}" wire:navigate class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-blue-900 to-blue-700 text-white font-semibold rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                    <span>Explore Our Products</span>
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 ml-2" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L12.586 11H5a1 1 0 110-2h7.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </a>
            </div>
        </div>
    </section>







<!-- ================= PRODUCTS SECTION ================= -->
<section class="py-20 relative overflow-hidden">
    <style>
        @keyframes fadeInUp {
            0% { 
                opacity: 0; 
                transform: translateY(30px); 
            }
            100% { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        @keyframes pulse {
            0%, 100% { 
                transform: scale(1); 
            }
            50% { 
                transform: scale(1.05); 
            }
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 0.8s ease-out forwards;
            opacity: 0;
        }
        
        .animate-pulse-slow {
            animation: pulse 4s ease-in-out infinite;
        }
        
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        .delay-400 { animation-delay: 0.4s; }
        
        .gradient-border {
            position: relative;
            background: linear-gradient(white, white) padding-box,
                        linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(168, 85, 247, 0.1)) border-box;
            border: 1px solid transparent;
        }
        
        .card-hover {
            transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        .card-hover:hover {
            transform: translateY(-10px);
        }
        
        .image-placeholder {
            background: linear-gradient(45deg, #f3f4f6, #e5e7eb);
        }
    </style>
        <!-- Background decorative elements -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-blue-900/5 rounded-full"></div>
            <div class="absolute -bottom-32 -left-32 w-80 h-80 bg-yellow-500/5 rounded-full"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl h-64 bg-gradient-to-r from-blue-900/5 to-yellow-500/5 blur-3xl rounded-full"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <!-- Section Header -->
           
            <div class="text-center mb-16">
                <div class="inline-flex items-center justify-center mb-6 animate-slide-in-left">
                    <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather', serif;">
                        Explore Our <span class="text-gradient">Products</span> 
                    </h2>
                </div>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto animate-fade-in-up">
                  Explore a wide range of wholesale categories including Pet Supplies, Beauty & Personal Care, Health & Household, Grocery & Gourmet, and Patio. Each category features high-quality, Amazon FBA-ready products sourced from trusted suppliers, helping you scale your business with profitable and fast-moving inventory.

                </p>
            </div>

            <!-- Products Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
                
                <!-- Product Card 1 -->
                @foreach($products as $product)
                <div class="group relative animate-fadeInUp delay-100">
                    <div class="absolute -inset-2 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-3xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200"></div>
                    <div class="relative gradient-border rounded-3xl overflow-hidden shadow-lg card-hover bg-white">
                        <!-- Product Image -->
                        <div class="relative h-56 overflow-hidden">
                            <div class="w-full h-full image-placeholder flex items-center justify-center">
                                <img src="{{asset('storage/' . $product->image)}}" alt="">
                            </div>
                            <!-- Hover Overlay -->
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end p-4">
                                <div class="transform translate-y-4 group-hover:translate-y-0 transition-transform duration-300">
                                    <span class="inline-block bg-white/20 backdrop-blur-sm text-white text-sm px-3 py-1 rounded-full">{{$product->category->name}}</span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Product Details -->
                        <div class="p-6">
                            <div class="flex items-start justify-between mb-3">
                                <h3 class="text-sm font-bold text-gray-800 flex-1">{{$product->name}}</h3>
                                <div class="flex items-center ml-2">
                                    <i class="fas fa-star text-yellow-400 text-sm"></i>
                                    <span class="text-gray-600 text-sm ml-1">4.8</span>
                                </div>
                            </div>
                            
                            {{-- <div class="flex items-center mb-4">
                                <span class="text-2xl font-bold text-indigo-600">$129.99</span>
                                <span class="text-sm text-gray-500 line-through ml-2">$159.99</span>
                                <span class="text-xs font-semibold bg-green-100 text-green-800 px-2 py-1 rounded-full ml-2">18% OFF</span>
                            </div> --}}
                            
                            <a href="{{route('user.apply-wholesale')}}" wire:navigate 
                               class="w-full inline-flex items-center justify-center bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-700 hover:to-purple-700 text-white font-semibold py-3 px-4 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 group">
                                <span>Apply for Wholesale</span>
                                <svg class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            
            <!-- Bottom CTA -->
            <div class="mt-16 text-center animate-fadeInUp delay-400">
                <div class="inline-flex flex-col sm:flex-row items-center justify-center space-y-4 sm:space-y-0 sm:space-x-6 bg-white/80 backdrop-blur-sm rounded-2xl p-6 shadow-lg border border-gray-200 max-w-2xl mx-auto">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-br from-indigo-500 to-purple-500 flex items-center justify-center shadow-md">
                            <i class="fas fa-boxes text-white"></i>
                        </div>
                        <div class="text-left">
                            <p class="font-bold text-gray-800">Need bulk pricing for your business?</p>
                            <p class="text-gray-600 text-sm">Contact us for custom wholesale solutions</p>
                        </div>
                    </div>
                    <a href="{{route('user.apply-wholesale')}}" wire:navigate class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-semibold rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 hover:scale-105">
                        Contact Sales
                    </a>
                </div>
            </div>
        </div>
    </section>

<section class="relative py-20 bg-dark-gradient overflow-hidden">
     <style>
        @keyframes fadeInLeft {
            0% { 
                opacity: 0; 
                transform: translateX(-30px); 
            }
            100% { 
                opacity: 1; 
                transform: translateX(0); 
            }
        }
        
        @keyframes fadeInRight {
            0% { 
                opacity: 0; 
                transform: translateX(30px); 
            }
            100% { 
                opacity: 1; 
                transform: translateX(0); 
            }
        }
        
        @keyframes fadeInUp {
            0% { 
                opacity: 0; 
                transform: translateY(20px); 
            }
            100% { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        .animate-fadeInLeft {
            animation: fadeInLeft 0.8s ease-out forwards;
            opacity: 0;
        }
        
        .animate-fadeInRight {
            animation: fadeInRight 0.8s ease-out forwards;
            opacity: 0;
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 0.8s ease-out forwards;
            opacity: 0;
        }
        
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        
        .gradient-overlay {
            background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.4) 50%, transparent 100%);
        }
        
        .card-hover {
            transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        .card-hover:hover {
            transform: translateY(-8px);
        }
        
        .scrollbar-hide {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }
        
        .bg-dark-gradient {
            background: linear-gradient(135deg, #1a202c 0%, #2d3748 100%);
        }
    </style>
        <!-- Background decorative elements -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-blue-900/10 rounded-full"></div>
            <div class="absolute -bottom-32 -left-32 w-80 h-80 bg-yellow-500/10 rounded-full"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl h-64 bg-gradient-to-r from-blue-900/10 to-yellow-500/10 blur-3xl rounded-full"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 grid grid-cols-1 lg:grid-cols-10 gap-12 items-center relative z-10">
            <!-- Left Column -->
            <div class="lg:col-span-3 flex flex-col items-center lg:items-start text-center lg:text-left animate-fadeInLeft">
                <!-- Decorative element -->
                <div class="flex items-center mb-6">
                    <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-white drop-shadow-lg" style="font-family: 'Merriweather','serif';">
                        Explore Our <span class="text-transparent bg-clip-text bg-gradient-to-r from-yellow-400 to-yellow-500">Categories</span>
                    </h2>
                </div>
                
                <p class="text-lg text-gray-300 mb-8 max-w-md leading-relaxed">
                    Discover our carefully curated product categories, each offering premium wholesale opportunities for your business.
                </p>
                
                <!-- Stats -->
                <div class="flex flex-col sm:flex-row gap-6 mt-4">
                    <div class="text-center lg:text-left">
                        <div class="text-3xl font-bold text-white">5+</div>
                        <div class="text-sm text-gray-400">Products Categories</div>
                    </div>
                    <div class="text-center lg:text-left">
                        <div class="text-3xl font-bold text-white">50+</div>
                        <div class="text-sm text-gray-400">Products</div>
                    </div>
                    <div class="text-center lg:text-left">
                        <div class="text-3xl font-bold text-white">100%</div>
                        <div class="text-sm text-gray-400">Satisfaction</div>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="lg:col-span-7 animate-fadeInRight">
                <!-- Header -->
                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between mb-10">
                    <div class="mb-4 sm:mb-0">
                        <h3 class="text-2xl sm:text-3xl font-bold text-white mb-2">Featured Categories</h3>
                        <p class="text-gray-400">Browse our most popular product categories</p>
                    </div>
                    <div class="flex space-x-3">
                        <button id="prevCommunity" class="p-3 rounded-full bg-gray-800 hover:bg-gray-700 text-white shadow-lg transition-all duration-300 hover:scale-110" aria-label="Previous">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                            </svg>
                        </button>
                        <button id="nextCommunity" class="p-3 rounded-full bg-gradient-to-r from-yellow-500 to-yellow-600 hover:from-yellow-600 hover:to-yellow-700 text-white shadow-lg transition-all duration-300 hover:scale-110" aria-label="Next">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Slider -->
                <div id="communitySlider" class="flex gap-6 overflow-x-auto scroll-smooth snap-x snap-mandatory pb-6 touch-pan-x scrollbar-hide">
                    <!-- Category 1 -->
                    @foreach($categories as $category)
                    
                        <div class="snap-center shrink-0 w-[85%] sm:w-[45%] lg:w-[30%] relative rounded-2xl overflow-hidden group cursor-pointer card-hover animate-fadeInUp">
                            <a href="{{route('user.products.by-category',$category->slug)}}" wire:navigate="">
                        <div class="w-full h-56 bg-white flex items-center justify-center">
                            <img src="{{asset('storage/' . $category->image)}}" alt="{{$category->name}}" class="w-[50%]] h-full object-cover">
                        </div>
                        <div class="absolute inset-0 gradient-overlay flex items-end p-6">
                            <div class="transform transition-transform duration-500 group-hover:translate-y-0 translate-y-2">
                                <div class="flex items-center mb-2">
                                    
                                    <h4 class="text-xl font-bold text-white">{{$category->name}}</h4>
                                </div>
                                
                            </div>
                        </div>
                    </a>

                    </div>
                    @endforeach
                </div>
                
                <!-- View All Button -->
                <div class="mt-10 text-center">
                    <a href="{{route('user.categories')}}" wire:navigate class="inline-flex items-center bg-transparent hover:bg-white/10 text-white font-semibold py-3 px-8 rounded-full border border-white/30 hover:border-white/50 transition-all duration-300 backdrop-blur-sm">
                        <span>View All Categories</span>
                        <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </section>

<section class="py-20 relative overflow-hidden">
    <style>
        @keyframes fadeInUp {
            0% { 
                opacity: 0; 
                transform: translateY(30px); 
            }
            100% { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        @keyframes float {
            0%, 100% { 
                transform: translateY(0); 
            }
            50% { 
                transform: translateY(-5px); 
            }
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 0.8s ease-out forwards;
            opacity: 0;
        }
        
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        
        .gradient-overlay {
            background: linear-gradient(to top, rgba(0,0,0,0.7) 0%, rgba(0,0,0,0.3) 50%, transparent 100%);
        }
        
        .card-hover {
            transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        .card-hover:hover {
            transform: translateY(-10px);
        }
        
        .line-clamp-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        
        .line-clamp-3 {
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        
        .text-gradient {
            background: linear-gradient(135deg, #1E293B, #4F46E5);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
        <!-- Background decorative elements -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-blue-900/5 rounded-full"></div>
            <div class="absolute -bottom-32 -left-32 w-80 h-80 bg-yellow-500/5 rounded-full"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl h-64 bg-gradient-to-r from-blue-900/5 to-yellow-500/5 blur-3xl rounded-full"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
            <!-- Section Header -->
            <div class="mb-16">
                <div class="flex items-center justify-center mb-6 animate-fadeInUp">
                    <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                        Latest <span class="text-gradient">News</span>
                    </h2>
                </div>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto animate-fadeInUp delay-100">
                    Stay updated with the latest industry insights, trends, and company announcements
                </p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- News Card 1 -->
                @foreach($blogs as $blog)
                <a href="{{route('user.blog.detail',$blog->slug)}}"  wire:navigate="" class="group animate-fadeInUp">
                    <article class="relative bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-500 overflow-hidden card-hover">
                        <div class="relative overflow-hidden">
                            <!-- Image with gradient overlay -->
                            <div class="w-full h-48 bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center">
                                <img src="{{asset('storage/' . $blog->image)}}" alt="{{$blog->title}}" class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500">
                            </div>
                            <div class="absolute top-4 left-4">
                                <span class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white px-3 py-1 text-xs font-bold rounded-full shadow-lg">{{$blog->category->name}}</span>
                            </div>
                            <div class="absolute inset-0 gradient-overlay opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end p-4">
                                <span class="text-white text-sm font-medium">Read More →</span>
                            </div>
                        </div>
                        <div class="p-6">
                            <h3 class="font-bold text-xl text-gray-900 mb-3 group-hover:text-indigo-700 transition-colors duration-300 line-clamp-2">
                                {{$blog->title}}
                            </h3>
                            
                            <div class="flex items-center justify-between text-sm text-gray-500 border-t pt-4">
                                <div class="flex items-center">
                                    <div class="w-6 h-6 rounded-full bg-indigo-100 flex items-center justify-center mr-2">
                                        <i class="fas fa-user text-indigo-600 text-xs"></i>
                                    </div>
                                    <span>Admin</span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-clock text-gray-400 mr-1"></i>
                                    <span>{{$blog->created_at->diffForHumans()}}</span>
                                </div>
                            </div>
                        </div>
                    </article>
                </a>
                @endforeach
            </div>
            
            <!-- View All Button -->
            <div class="mt-12 animate-fadeInUp delay-300">
                <a href="{{route('user.blogs')}}" wire:navigate class="inline-flex items-center bg-gradient-to-r from-[#232F3E] to-indigo-700 hover:from-indigo-700 hover:to-[#232F3E] text-white font-semibold py-3 px-8 rounded-full shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
                    <span>View All News</span>
                    <svg class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path>
                    </svg>
                </a>
            </div>
        </div>
    </section>
   
</div>