@section('meta-content')
@php
    $settings = \App\Models\Setting::find(1);
@endphp
    @if($settings)<title>{{$settings->site_title}}</title>@endif
    <meta name="title" content="@if($product){{$product->meta_title}}@endif">
    <meta name="description" content="@if($product){{$product->meta_description}}@endif">
    <meta name="tags" content="@if($product){{$product->meta_tags}}@endif">
    <meta name="keywords" content="@if($product){{$product->meta_keywords}}@endif">
    @if($product)<script>{!!$product->page_schema !!}</script>@endif
@endsection
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100">
    <!-- Breadcrumb Navigation -->
    
<style>
.prose {
    line-height: 1.75;
}

.prose h1, .prose h2, .prose h3, .prose h4 {
    margin-top: 1em;
    margin-bottom: 0.5em;
    font-weight: 700;
}

.prose h2 {
    font-size: 1.25em;
    border-bottom: 2px solid #4f46e5;
    padding-bottom: 0.25em;
}

.prose p {
    margin-bottom: 1em;
}

.prose ul, .prose ol {
    margin: 1em 0;
    padding-left: 1.5em;
}

.prose li {
    margin: 0.5em 0;
}

.prose strong {
    color: #1f2937;
    font-weight: 700;
}

.prose table {
    width: 100%;
    border-collapse: collapse;
    margin: 1.5em 0;
    border-radius: 0.5rem;
    overflow: hidden;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.prose th, .prose td {
    border: 1px solid #e5e7eb;
    padding: 0.75em;
    text-align: left;
}

.prose th {
    background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
    color: white;
    font-weight: 600;
}
</style>
    <div class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-6 py-4">
            <nav class="text-gray-600 text-sm">
                <ul class="flex items-center space-x-2">
                    <li><a href="/" class="text-blue-500 hover:text-blue-600 hover:underline transition-colors duration-300">Home</a></li>
                    <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                    <li class="text-gray-500">Products</li>
                    @php
                    $category = \App\Models\Category::find($product->category_id);
                    @endphp
                    <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                    <li class="text-gray-500">{{$category->name}}</li>
                    <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                    <li class="text-gray-900 font-medium">{{$product->slug}}</li>
                </ul>
            </nav>
        </div>
    </div>

    <!-- Product Detail Section -->
    <section class="max-w-7xl mx-auto px-6 py-16">
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 p-8">
                <!-- Product Image -->
                <picture>
                                <source srcset="{{asset('storage/' .$product->image) }}" type="image/webp" class="rounded-lg shadow-2xl w-full max-w-md transform group-hover:scale-105 transition-transform duration-500">
                                <img src="{{asset('storage/' .$product->image) }}" alt="{{$product->name}}" class="rounded-lg shadow-2xl w-full max-w-md transform group-hover:scale-105 transition-transform duration-500">
                            </picture>

                <!-- Product Details -->
                <div class="flex flex-col justify-center">
                    <!-- Product Header -->
                    <div class="mb-6">
                        <div class="flex items-center mb-4">
                            <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                            <h1 class="text-3xl lg:text-4xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">{{$product->name}}</h1>
                        </div>
                        
                        <!-- Product Stats -->
                        <div class="flex flex-wrap gap-4 mb-6">
                            <div class="flex items-center text-gray-600">
                                <div class="w-10 h-10 bg-green-100 rounded-xl flex items-center justify-center mr-3">
                                    <i class="fas fa-box text-green-600"></i>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Minimum Order</p>
                                    <p class="font-semibold text-gray-900">{{$product->moq}} units</p>
                                </div>
                            </div>
                            
                            <div class="flex items-center text-gray-600">
                                <div class="w-10 h-10 bg-blue-100 rounded-xl flex items-center justify-center mr-3">
                                    <i class="fas fa-shipping-fast text-blue-600"></i>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Availability</p>
                                    <p class="font-semibold text-gray-900">In Stock</p>
                                </div>
                            </div>
                            
                            <div class="flex items-center text-gray-600">
                                <div class="w-10 h-10 bg-purple-100 rounded-xl flex items-center justify-center mr-3">
                                    <i class="fas fa-star text-purple-600"></i>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Quality</p>
                                    <p class="font-semibold text-gray-900">Premium Grade</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Product Description -->
                    <div class="mb-8">
                        <h2 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-clipboard-list text-indigo-600 mr-3"></i>
                            Product Details
                        </h2>
                        <div class="prose prose-lg max-w-none text-gray-700 leading-relaxed">
                            {!!$product->description!!}
                        </div>
                    </div>

                    <!-- Key Features -->
                    <div class="mb-8">
                        <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            Key Features
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                            <div class="flex items-center">
                                <i class="fas fa-check text-green-500 mr-3"></i>
                                <span class="text-gray-700">Premium Quality Materials</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check text-green-500 mr-3"></i>
                                <span class="text-gray-700">Competitive Wholesale Pricing</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check text-green-500 mr-3"></i>
                                <span class="text-gray-700">Fast Shipping Available</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check text-green-500 mr-3"></i>
                                <span class="text-gray-700">Bulk Order Discounts</span>
                            </div>
                        </div>
                    </div>

                    <!-- Wholesale Application Button -->
                    <div class="mt-auto">
                        <a href="{{route('user.apply-wholesale')}}" wire:navigate 
                           class="w-full bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-700 hover:to-purple-700 text-white font-bold py-4 px-8 rounded-xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl flex items-center justify-center group">
                            <i class="fas fa-truck-loading mr-3 text-lg"></i>
                            <span class="text-lg">Apply for Wholesale Pricing</span>
                            <i class="fas fa-arrow-right ml-3 transform group-hover:translate-x-1 transition-transform duration-300"></i>
                        </a>
                        
                        <p class="text-center text-gray-500 text-sm mt-4">
                            Wholesale pricing available for qualified businesses
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Information Sections -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mt-12">
            <!-- Shipping Information -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center mr-4">
                        <i class="fas fa-shipping-fast text-white text-xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900">Shipping & Delivery</h3>
                </div>
                <p class="text-gray-600 mb-4">
                    Fast and reliable shipping options available for wholesale orders. Track your shipment in real-time.
                </p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>Standard: 3-5 business days</span>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>Express: 1-2 business days</span>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>International shipping available</span>
                    </li>
                </ul>
            </div>

            <!-- Quality Assurance -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-teal-500 rounded-xl flex items-center justify-center mr-4">
                        <i class="fas fa-award text-white text-xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900">Quality Assurance</h3>
                </div>
                <p class="text-gray-600 mb-4">
                    All products undergo strict quality control to ensure they meet our high standards and your expectations.
                </p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>100% quality inspected</span>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>Premium materials only</span>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>Industry standards compliant</span>
                    </li>
                </ul>
            </div>

            <!-- Wholesale Benefits -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-500 rounded-xl flex items-center justify-center mr-4">
                        <i class="fas fa-chart-line text-white text-xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900">Wholesale Benefits</h3>
                </div>
                <p class="text-gray-600 mb-4">
                    Join our wholesale program to unlock exclusive benefits and grow your business.
                </p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>Competitive pricing</span>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>Volume discounts</span>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-500 mr-2"></i>
                        <span>Priority customer support</span>
                    </li>
                </ul>
            </div>
        </div>

        
    </section>
</div>
