<div class="relative" x-data="{ showResults: @entangle('showResults') }">
    <div class="relative">
        <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-400" 
             fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
        </svg>
        
        <input 
            type="text" 
            wire:model.debounce.300ms="query"
            placeholder="Search for news, articles, blogs..."
            class="w-full pl-10 pr-10 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            x-on:click.outside="showResults = false"
            autocomplete="off"
        >
        
        @if($query)
            <button wire:click="clearSearch" class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-gray-600">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        @endif
    </div>

    <!-- Search Results Dropdown -->
    <div x-show="showResults && searchResults.length > 0" 
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 transform -translate-y-2"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         class="absolute top-full left-0 right-0 bg-white shadow-xl border border-gray-200 rounded-lg mt-2 max-h-96 overflow-y-auto z-50">
        
        <div class="p-2 space-y-1">
            @foreach($searchResults as $result)
                <button 
                    wire:click="selectResult({{ $result['id'] }})"
                    class="w-full text-left p-3 hover:bg-blue-50 rounded-lg transition-colors duration-200 flex items-start space-x-3"
                >
                    @if(isset($result['featured_image']) && $result['featured_image'])
                        <img src="{{ Storage::url($result['featured_image']) }}" 
                             alt="{{ $result['title'] }}"
                             class="w-12 h-12 rounded-lg object-cover flex-shrink-0">
                    @else
                        <div class="w-12 h-12 bg-gray-200 rounded-lg flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                            </svg>
                        </div>
                    @endif
                    
                    <div class="flex-1 min-w-0">
                        <h4 class="text-sm font-semibold text-gray-900 truncate">
                            {{ $result['title'] }}
                        </h4>
                        <p class="text-xs text-gray-500 mt-1 line-clamp-2">
                            @php
                                $content = $result['excerpt'] ?? $result['content'] ?? '';
                                echo Str::limit(strip_tags($content), 80);
                            @endphp
                        </p>
                        <div class="flex items-center space-x-2 mt-1">
                            @if(isset($result['category']['name']))
                                <span class="text-xs text-blue-600 font-medium">
                                    {{ $result['category']['name'] }}
                                </span>
                                <span class="text-xs text-gray-400">•</span>
                            @endif
                            <span class="text-xs text-gray-500">
                                {{ \Carbon\Carbon::parse($result['created_at'])->diffForHumans() }}
                            </span>
                        </div>
                    </div>
                </button>
            @endforeach
        </div>
    </div>

    <!-- No Results -->
    <div x-show="showResults && searchResults.length === 0 && query.length > 2" 
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 transform -translate-y-2"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         class="absolute top-full left-0 right-0 bg-white shadow-xl border border-gray-200 rounded-lg mt-2 p-4 z-50">
        <div class="text-center text-gray-500">
            <svg class="w-8 h-8 mx-auto text-gray-400 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <p class="text-sm">No results found for "{{ $query }}"</p>
            <p class="text-xs mt-1">Try different keywords or browse categories</p>
        </div>
    </div>
</div>