<?php

use App\Http\Livewire\User\Search;
use App\Livewire\Admin\Banners;
use App\Livewire\Admin\Blogs;
use App\Livewire\Admin\Brands;
use App\Livewire\Admin\Categories;
use App\Livewire\Admin\Dashboard;
use App\Livewire\Admin\Leads;
use App\Livewire\Admin\PageMetaService;
use App\Livewire\Admin\Pages;
use App\Livewire\Admin\Products;
use App\Livewire\Admin\Settings;
use App\Livewire\Admin\SiteDataDashboard;
use App\Livewire\Admin\SubCategories;
use App\Livewire\Admin\Users;
use App\Livewire\Auth\Login;
use App\Livewire\Auth\Logout;
use App\Livewire\SitemapGenerator;
use App\Livewire\User\About;
use App\Livewire\User\ApplyWholesale;
use App\Livewire\User\BlogDetail;
use App\Livewire\User\BlogPage;
use App\Livewire\User\BrandPage;
use App\Livewire\User\Home;
use App\Livewire\User\Services;
use App\Livewire\User\CategoryPage;
use App\Livewire\User\Contact;
use App\Livewire\User\Policies;
use App\Livewire\User\ProductByCategory;
use App\Livewire\User\ProductDetail;
use App\Livewire\User\ProductPage;
use App\Livewire\Admin\Websites;
use App\Livewire\Google\AnalyticsDashboard;
use App\Livewire\User\BlogsByCategory;
use Illuminate\Support\Facades\Route;

// Route::get('/', function () {
//     return view('welcome');
// });
// Authentication routes (if using Laravel UI or Breeze)
Route::get('/login', Login::class)->name('login');
Route::get('/logout', Logout::class)->name('logout');

Route::get('/seller-dashboard', SiteDataDashboard::class);

// Admin routes group
Route::middleware(['auth','preventback'])->prefix('admin')->name('admin.')->group(function () {
    
    // Dashboard
    Route::get('/dashboard', Dashboard::class)->name('dashboard');
    Route::get('/analytics', AnalyticsDashboard::class)->name('analytics');

    
    // User Management
   Route::get('/users', Users::class)->name('users');

    // Leads Management (if you implement it)
    Route::get('/leads', Leads::class)->name('leads');
    // Content Management
    Route::get('/blogs', Blogs::class)->name('blogs');
    Route::get('/brands', Brands::class)->name('brands');
    Route::get('/banners', Banners::class)->name('banners');
    Route::get('/pages', Pages::class)->name('pages');
    
    // Product Management
    Route::get('/products', Products::class)->name('products');
    Route::get('/categories', Categories::class)->name('categories');
    Route::get('/sub-categories', SubCategories::class)->name('subcategories');
    
    // SEO Management
    
    Route::get('/seo-settings', PageMetaService::class)->name('seo');
    // Application Settings
    Route::get('/settings', Settings::class)->name('settings');

    Route::get('/websites', Websites::class)->name('websites');
    
    // Home route redirect to dashboard
    Route::get('/', function () {
        return redirect()->route('admin.dashboard');
    });
});



Route::get('/', Home::class)->name('user.home');
Route::get('about', About::class)->name('user.about');
Route::get('contact', Contact::class)->name('user.contact');
Route::get('services', Services::class)->name('user.services');
Route::get('categories', CategoryPage::class)->name('user.categories');
Route::get('products', ProductPage::class)->name('user.products');
Route::get('product/{slug}', ProductDetail::class)->name('user.product.detail');
Route::get('brands', BrandPage::class)->name('user.brands');
Route::get('topics', BlogPage::class)->name('user.blogs');
Route::get('topic/{slug}', BlogDetail::class)->name('user.blog.detail');
Route::get('topics/{categoryslug}/{subcategoryslug}/', BlogsByCategory::class)->name('user.blog.by-category');
Route::get('apply-wholesale', ApplyWholesale::class)->name('user.apply-wholesale');
Route::get('/{slug}/products', ProductByCategory::class)->name('user.products.by-category');
Route::get('/policies/{slug}/', Policies::class)->name('user.policies');



// HTML Sitemap (Livewire component)
Route::get('/sitemap', SitemapGenerator::class)->name('sitemap');

// XML Sitemap download
Route::get('/sitemap/download', [SitemapGenerator::class, 'downloadXml'])->name('sitemap.download');

// XML Sitemap view
Route::get('/sitemap.xml', [SitemapGenerator::class, 'viewXml'])->name('sitemap.xml');
