<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100">
    <style>
.prose {
    line-height: 1.75;
}

.prose h1, .prose h2, .prose h3, .prose h4 {
    margin-top: 2em;
    margin-bottom: 1em;
    font-weight: 700;
}

.prose h2 {
    font-size: 1.5em;
    border-bottom: 2px solid #4f46e5;
    padding-bottom: 0.5em;
}

.prose p {
    margin-bottom: 1.5em;
}

.prose img {
    border-radius: 0.75rem;
    margin: 2em 0;
    box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
}

.prose blockquote {
    border-left-width: 4px;
    padding: 1.5em 2em;
    margin: 2em 0;
    border-radius: 0.75rem;
    background: linear-gradient(135deg, #f0f4ff 0%, #f8faff 100%);
}

.prose ul, .prose ol {
    margin: 1.5em 0;
    padding-left: 1.5em;
}

.prose li {
    margin: 0.5em 0;
}

.prose table {
    width: 100%;
    border-collapse: collapse;
    margin: 2em 0;
    border-radius: 0.75rem;
    overflow: hidden;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.prose th, .prose td {
    border: 1px solid #e5e7eb;
    padding: 1em;
    text-align: left;
}

.prose th {
    background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
    color: white;
    font-weight: 600;
}

.prose code {
    background: #f1f5f9;
    padding: 0.25em 0.5em;
    border-radius: 0.375rem;
    font-size: 0.875em;
    color: #475569;
}
</style>
    <!-- Breadcrumb Navigation -->
    <div class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-6 py-4">
            <nav class="text-gray-600 text-sm">
                <ul class="flex items-center space-x-2">
                    <li><a href="/" class="text-blue-500 hover:text-blue-600 hover:underline transition-colors duration-300">Home</a></li>
                    <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                    <li class="text-gray-500 capitalize"><?php echo e($policy->slug); ?></li>
                </ul>
            </nav>
        </div>
    </div>

    <!-- Policy Content Section -->
    <section class="max-w-7xl mx-auto px-6 py-16">
        <!-- Header Section -->
        <div class="text-center mb-16">
            <div class="flex items-center justify-center mb-6">
                <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                <h1 class="text-4xl md:text-5xl font-bold text-gray-900 capitalize" style="font-family: 'Merriweather','serif';">
                    <?php echo e($policy->slug); ?>

                </h1>
            </div>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Important information about our policies and procedures
            </p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-4 gap-12">
            <!-- Main Content -->
            <div class="lg:col-span-3">
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                    <!-- Content Header -->
                    <div class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white p-8">
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center mr-4">
                                <i class="fas fa-file-contract text-white text-xl"></i>
                            </div>
                            <div>
                                <h2 class="text-2xl font-bold">Policy Details</h2>
                                <p class="text-indigo-100 mt-1">Last updated: <?php echo e(now()->format('F j, Y')); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Policy Content -->
                    <div class="p-8">
                        <div class="prose prose-lg max-w-none 
                                    prose-headings:text-gray-900 prose-headings:font-bold
                                    prose-p:text-gray-700 prose-p:leading-relaxed
                                    prose-a:text-indigo-600 prose-a:no-underline hover:prose-a:underline
                                    prose-blockquote:border-l-4 prose-blockquote:border-indigo-600 prose-blockquote:bg-indigo-50 prose-blockquote:italic prose-blockquote:pl-6
                                    prose-strong:text-gray-900
                                    prose-ul:text-gray-700 prose-ol:text-gray-700
                                    prose-table:border-collapse prose-table:border prose-table:border-gray-300
                                    prose-th:bg-gray-100 prose-th:text-gray-900 prose-th:p-4
                                    prose-td:p-4 prose-td:border prose-td:border-gray-300">
                            <?php echo $policy->details; ?>

                        </div>
                    </div>
                </div>

                <!-- Wholesale Distributors Form -->
                <!--[if BLOCK]><![endif]--><?php if($policy->slug == 'wholesale-distributors'): ?>
                <div class="mt-12">
                    <!-- Form Header -->
                    <div class="text-center mb-12">
                        <div class="flex items-center justify-center mb-6">
                            <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                            <h2 class="text-4xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                                Apply for <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-purple-600">Wholesale</span>
                            </h2>
                        </div>
                        <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                            Join our network of trusted wholesale distributors
                        </p>
                    </div>

                    <!-- Success/Error Messages -->
                    <div class="mb-8">
                        <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
                            <div class="bg-green-50 border-l-4 border-green-500 p-6 rounded-2xl shadow-sm mb-6">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-check-circle text-green-500 text-2xl"></i>
                                    </div>
                                    <div class="ml-4">
                                        <p class="text-green-700 font-semibold text-lg"><?php echo e(session('success')); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <?php if(session()->has('error')): ?>
                            <div class="bg-red-50 border-l-4 border-red-500 p-6 rounded-2xl shadow-sm mb-6">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-exclamation-circle text-red-500 text-2xl"></i>
                                    </div>
                                    <div class="ml-4">
                                        <p class="text-red-700 font-semibold text-lg"><?php echo e(session('error')); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Application Form -->
                    <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                        <div class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white p-8">
                            <h3 class="text-2xl font-bold flex items-center">
                                <i class="fas fa-id-card mr-3"></i>
                                Wholesale Application Form
                            </h3>
                            <p class="text-indigo-100 mt-2">Please fill out all required fields to apply for wholesale distribution</p>
                        </div>

                        <div class="p-8">
                            <form wire:submit="store" class="space-y-8" enctype="multipart/form-data">
                                <input type="hidden" name="source" wire:model="source">
                                
                                <!-- Personal Information Section -->
                                <div class="border-b border-gray-200 pb-8">
                                    <h4 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                                        <i class="fas fa-user text-indigo-600 mr-3"></i>
                                        Personal Information
                                    </h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                        <!-- Firstname -->
                                        <div>
                                            <label for="firstname" class="block text-gray-700 font-medium mb-3">First Name</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="firstname" 
                                                       id="firstname" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter First Name">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Lastname -->
                                        <div>
                                            <label for="lastname" class="block text-gray-700 font-medium mb-3">Last Name</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="lastname" 
                                                       id="lastname" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter Last Name">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Company Name -->
                                        <div>
                                            <label for="companyname" class="block text-gray-700 font-medium mb-3">Company Name</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="companyname" 
                                                       id="companyname" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['companyname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter Company Name">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['companyname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['companyname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <!-- Contact Information Section -->
                                <div class="border-b border-gray-200 pb-8">
                                    <h4 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                                        <i class="fas fa-address-card text-indigo-600 mr-3"></i>
                                        Contact Information
                                    </h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                        <!-- Email -->
                                        <div>
                                            <label for="email" class="block text-gray-700 font-medium mb-3">Email Address</label>
                                            <div class="relative">
                                                <input type="email" 
                                                       wire:model="email" 
                                                       id="email" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter Email Address">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Phone -->
                                        <div>
                                            <label for="phone" class="block text-gray-700 font-medium mb-3">Phone Number</label>
                                            <div class="relative">
                                                <input type="number" 
                                                       wire:model="phone" 
                                                       id="phone" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter Phone Number">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Employee ID -->
                                        <div>
                                            <label for="employeeid" class="block text-gray-700 font-medium mb-3">Employee ID</label>
                                            <div class="relative">
                                                <input type="number" 
                                                       wire:model="employeeid" 
                                                       id="employeeid" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['employeeid'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter Employee ID">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['employeeid'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['employeeid'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <!-- Address Information Section -->
                                <div class="border-b border-gray-200 pb-8">
                                    <h4 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                                        <i class="fas fa-map-marker-alt text-indigo-600 mr-3"></i>
                                        Address Information
                                    </h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                        <!-- Address Primary -->
                                        <div class="md:col-span-2">
                                            <label for="address_primary" class="block text-gray-700 font-medium mb-3">Primary Address</label>
                                            <input type="text" 
                                                   wire:model="address_primary" 
                                                   id="address_primary" 
                                                   class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['address_primary'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   placeholder="Enter Primary Address">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['address_primary'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Address Secondary -->
                                        <div>
                                            <label for="address_secondary" class="block text-gray-700 font-medium mb-3">Secondary Address</label>
                                            <input type="text" 
                                                   wire:model="address_secondary" 
                                                   id="address_secondary" 
                                                   class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300" 
                                                   placeholder="Enter Secondary Address (Optional)">
                                        </div>

                                        <!-- Country -->
                                        <div>
                                            <label for="country" class="block text-gray-700 font-medium mb-3">Country</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="country" 
                                                       id="country" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter Country">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- State -->
                                        <div>
                                            <label for="state" class="block text-gray-700 font-medium mb-3">State</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="state" 
                                                       id="state" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter State">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- City -->
                                        <div>
                                            <label for="city" class="block text-gray-700 font-medium mb-3">City</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="city" 
                                                       id="city" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Enter City">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <!-- Business Information Section -->
                                <div class="border-b border-gray-200 pb-8">
                                    <h4 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                                        <i class="fas fa-briefcase text-indigo-600 mr-3"></i>
                                        Business Information
                                    </h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                        <!-- Seller Permit -->
                                        <div>
                                            <label for="seller_permit" class="block text-gray-700 font-medium mb-3">Seller Permit Number</label>
                                            <div class="relative">
                                                <input type="number" 
                                                       wire:model="seller_permit" 
                                                       id="seller_permit" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['seller_permit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Seller's Permit / Reseller Certificate">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['seller_permit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['seller_permit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Period -->
                                        <div>
                                            <label for="period" class="block text-gray-700 font-medium mb-3">Years in Business</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="period" 
                                                       id="period" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['period'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="How long have you been in this business?">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['period'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['period'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Location -->
                                        <div>
                                            <label for="location" class="block text-gray-700 font-medium mb-3">Sales Channels</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="location" 
                                                       id="location" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="Where do you sell? (e.g., Online, Retail Store)">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!-- Reference -->
                                        <div class="md:col-span-2">
                                            <label for="reference" class="block text-gray-700 font-medium mb-3">How did you hear about us?</label>
                                            <div class="relative">
                                                <input type="text" 
                                                       wire:model="reference" 
                                                       id="reference" 
                                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       placeholder="How did you hear about us?">
                                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                        <i class="fas fa-exclamation-circle text-red-500"></i>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                                </p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <!-- Document Upload Section -->
                                <div class="pb-8">
                                    <h4 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                                        <i class="fas fa-file-upload text-indigo-600 mr-3"></i>
                                        Document Upload
                                    </h4>
                                    
                                    <!-- Permit Document -->
                                    <div class="w-full">
                                        <label for="permit_doc" class="block text-gray-700 font-medium mb-3">Upload Seller's Permit or Reseller Certificate</label>
                                        <div class="border-2 border-dashed border-gray-300 rounded-2xl p-8 text-center cursor-pointer hover:border-indigo-400 hover:bg-indigo-50 transition-all duration-300" 
                                             onclick="document.getElementById('permit_doc').click()">
                                            <input type="file" 
                                                   wire:model="permit_doc" 
                                                   id="permit_doc" 
                                                   class="sr-only">
                                            <div class="flex flex-col items-center justify-center">
                                                <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-4"></i>
                                                <p class="text-gray-600 font-medium mb-2">
                                                    <span wire:loading.remove wire:target="permit_doc">
                                                        <!--[if BLOCK]><![endif]--><?php if($permit_doc): ?>
                                                            <?php echo e($permit_doc->getClientOriginalName()); ?>

                                                        <?php else: ?>
                                                            Click to upload your document
                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    </span>
                                                    <span wire:loading wire:target="permit_doc" class="flex items-center">
                                                        <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-indigo-500 mr-2"></div>
                                                        Uploading...
                                                    </span>
                                                </p>
                                                <p class="text-gray-500 text-sm">PDF, JPG, or PNG (Max 5MB)</p>
                                            </div>
                                        </div>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['permit_doc'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="text-red-600 text-sm mt-2 flex items-center">
                                                <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                            </p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        
                                        <!--[if BLOCK]><![endif]--><?php if($permit_doc): ?>
                                            <div class="mt-4 text-sm text-green-600 flex items-center bg-green-50 p-4 rounded-xl">
                                                <i class="fas fa-check-circle mr-2"></i>
                                                File selected: <?php echo e($permit_doc->getClientOriginalName()); ?>

                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <!-- Submit Button -->
                                <div class="pt-6">
                                    <button type="submit" 
                                            wire:loading.attr="disabled"
                                            class="w-full bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-bold py-4 px-8 rounded-xl hover:from-indigo-700 hover:to-purple-700 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center">
                                        <span wire:loading.remove wire:target="store" class="flex items-center">
                                            <i class="fas fa-paper-plane mr-3"></i>
                                            Submit Wholesale Application
                                        </span>
                                        <span wire:loading wire:target="store" class="flex items-center">
                                            <div class="animate-spin rounded-full h-5 w-5 border-b-2 border-white mr-3"></div>
                                            Processing Your Application...
                                        </span>
                                    </button>
                                    <p class="text-center text-gray-500 text-sm mt-4">
                                        By submitting this form, you agree to our <a href="#" class="text-indigo-600 hover:underline">Terms & Conditions</a> and <a href="#" class="text-indigo-600 hover:underline">Privacy Policy</a>
                                    </p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1">
                <div class="space-y-6 sticky top-8">
                    <!-- Quick Links -->
                    <div class="bg-white rounded-2xl shadow-lg p-6">
                        <h3 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-link text-indigo-600 mr-3"></i>
                            Quick Links
                        </h3>
                        <ul class="space-y-3">
                            <?php
                                $footerPages = \App\Models\Page::all();
                            ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $footerPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('user.policies',$page->slug)); ?>" class="flex items-center text-gray-700 hover:text-indigo-600 transition-colors duration-300 py-2">
                                    <i class="fas fa-chevron-right text-indigo-400 text-xs mr-3"></i>
                                    <?php echo e($page->title); ?>

                                </a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </ul>
                    </div>

                    <!-- Contact Support -->
                    <div class="bg-gradient-to-br from-indigo-600 to-purple-600 rounded-2xl p-6 text-white">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-headset text-white text-2xl"></i>
                            </div>
                            <h3 class="text-xl font-bold mb-2">Need Help?</h3>
                            <p class="text-indigo-100 text-sm mb-4">
                                Our support team is here to assist you with any questions.
                            </p>
                            <a href="#" class="inline-block bg-white text-indigo-600 font-bold py-3 px-6 rounded-xl hover:bg-gray-100 transition-colors duration-300">
                                Contact Support
                            </a>
                        </div>
                    </div>

                    <!-- Policy Updates -->
                    <div class="bg-white rounded-2xl shadow-lg p-6">
                        <h3 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-bell text-indigo-600 mr-3"></i>
                            Policy Updates
                        </h3>
                        <p class="text-gray-600 text-sm mb-4">
                            Stay informed about important policy changes and updates.
                        </p>
                        <form class="space-y-3">
                            <input type="email" 
                                   placeholder="Enter your email" 
                                   class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent text-sm">
                            <button class="w-full bg-indigo-600 text-white font-semibold py-3 rounded-xl hover:bg-indigo-700 transition-colors duration-300 text-sm">
                                Subscribe to Updates
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /home/realzjjm/saas.dreamzplanet.com/resources/views/livewire/user/policies.blade.php ENDPATH**/ ?>