<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100">
    <!-- Breadcrumb Navigation -->
    <div class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-6 py-4">
            <nav class="text-gray-600 text-sm">
                <ul class="flex items-center space-x-2">
                    <li><a href="/" class="text-blue-500 hover:text-blue-600 hover:underline transition-colors duration-300">Home</a></li>
                    <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                    <li class="text-gray-500">Products By Categories</li>
                </ul>
            </nav>
        </div>
    </div>

    <div class="max-w-7xl mx-auto p-6">
        <div class="grid grid-cols-12 gap-8">
            <!-- Main Content -->
            <div class="col-span-12">
                <!-- Category Profile -->
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden mb-8">
                    <div class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white p-8">
                        <div class="flex flex-col md:flex-row items-center space-y-6 md:space-y-0 md:space-x-8">
                            <!--[if BLOCK]><![endif]--><?php if($category->feature_image): ?>
                                <div class="flex-shrink-0">
                                    <picture>
                                        <source srcset="<?php echo e(Storage::url($category->image)); ?>" type="image/webp" class="w-48 h-48 object-cover rounded-2xl shadow-lg">
                                        <img src="<?php echo e(Storage::url($category->image)); ?>" alt="<?php echo e($category->name); ?>" class="w-48 h-48 object-cover rounded-2xl shadow-lg">
                                    </picture>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <div class="text-center md:text-left">
                                <h1 class="text-4xl font-bold mb-4" style="font-family: 'Merriweather','serif';"><?php echo e($category->name); ?></h1>
                                <p class="text-indigo-100 text-lg leading-relaxed max-w-3xl"><?php echo $category->description; ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Featured Products Section -->
                <div class="mb-16">
                    <div class="text-center mb-12">
                        <div class="flex items-center justify-center mb-6">
                            <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                            <h2 class="text-4xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                                Featured <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-purple-600">Products</span>
                            </h2>
                        </div>
                        <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                            Discover our premium selection of products in this category
                        </p>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            
                            <div class="group relative animate-fadeInUp delay-100">
                                <div class="absolute -inset-2 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-3xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200"></div>
                                <div class="relative gradient-border rounded-3xl overflow-hidden shadow-lg card-hover bg-white">
                                    <!-- Product Image -->
                                    <a href="<?php echo e(route('user.product.detail', $product->slug)); ?>" wire:navigate>
                                    <div class="relative h-56 overflow-hidden">
                                        
                                                    <picture>
                                                        <source srcset="<?php echo e(asset('storage/' . $product->image)); ?>" type="image/webp" class="w-full h-64 object-cover transition-transform duration-700 group-hover:scale-110">
                                                        <img src="<?php echo e(asset('storage/' . $product->image)); ?>" alt="<?php echo e($product->name); ?>" class="w-full h-64 object-cover transition-transform duration-700 group-hover:scale-110">
                                                    </picture>
                                              
                                        <!-- Hover Overlay -->
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end p-4">
                                            <div class="transform translate-y-4 group-hover:translate-y-0 transition-transform duration-300">
                                                <span class="inline-block bg-white/20 backdrop-blur-sm text-white text-sm px-3 py-1 rounded-full"><?php echo e($product->category->name); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                      </a>
                                    <!-- Product Details -->
                                    <div class="p-6">
                                        <div class="flex items-start justify-between mb-3">
                                            <h3 class="text-sm font-bold text-gray-800 flex-1"><?php echo e($product->name); ?></h3>
                                            <div class="flex items-center ml-2">
                                                <i class="fas fa-star text-yellow-400 text-sm"></i>
                                                <span class="text-gray-600 text-sm ml-1">4.8</span>
                                            </div>
                                        </div>
                                        
                                        <div class="flex items-center justify-between mb-4">
                                            <span class="text-sm text-gray-600 font-medium">Minimum Order Quantity:</span>
                                            <span class="text-indigo-600 font-bold"><?php echo e($product->moq); ?></span>
                                        </div>
                                        
                                        <a href="<?php echo e(route('user.apply-wholesale')); ?>" wire:navigate 
                                        class="w-full inline-flex items-center justify-center bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-700 hover:to-purple-700 text-white font-semibold py-3 px-4 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 group">
                                            <span>Apply for Wholesale</span>
                                            <svg class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-span-4 text-center py-12">
                                <div class="w-24 h-24 bg-gray-200 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <i class="fas fa-box-open text-gray-400 text-3xl"></i>
                                </div>
                                <p class="text-gray-500 text-lg">No products available in this category.</p>
                                <p class="text-gray-400 mt-2">Check back later for new arrivals.</p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>

        <!-- Categories Section -->
        <section class="py-16">
            <div class="text-center mb-12">
                <div class="flex items-center justify-center mb-6">
                    <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                        Explore <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-purple-600">Categories</span>
                    </h2>
                </div>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                    Browse our wide range of product categories
                </p>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-6">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="group bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-500 overflow-hidden transform hover:-translate-y-2">
                        <div class="p-6 flex flex-col items-center text-center">
                            <!-- Category Image -->
                            <div class="w-20 h-20 mb-4 rounded-2xl bg-gradient-to-br from-indigo-100 to-purple-100 flex items-center justify-center group-hover:from-indigo-200 group-hover:to-purple-200 transition-all duration-300">
                                <picture>
                                    <source srcset="<?php echo e(asset('storage/' . $cate->image)); ?>" type="image/webp" class="w-16 h-16 object-cover rounded-xl">
                                    <img src="<?php echo e(asset('storage/' . $cate->image)); ?>" alt="<?php echo e($cate->name); ?>" class="w-16 h-16 object-cover rounded-xl">
                                </picture>
                            </div>
                            
                            <!-- Category Name -->
                            <h3 class="text-lg font-semibold text-gray-900 mb-3 group-hover:text-indigo-700 transition-colors duration-300">
                                <?php echo e($cate->name); ?>

                            </h3>
                            
                            <!-- View Products Link -->
                            <a href="<?php echo e(route('user.products.by-category', $cate->slug)); ?>" wire:navigate 
                               class="inline-flex items-center text-indigo-600 hover:text-indigo-700 font-medium transition-colors duration-300 group/link">
                                <span>View Products</span>
                                <i class="fas fa-arrow-right ml-2 transform group-hover/link:translate-x-1 transition-transform duration-300"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </section>
    </div>
</div>

<?php /**PATH /home/amersjqb/minmaxsolutionsllc.com/resources/views/livewire/user/product-by-category.blade.php ENDPATH**/ ?>