<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\Setting::find(1);
?>
    <!--[if BLOCK]><![endif]--><?php if($settings): ?><title><?php echo e($settings->site_title); ?></title><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
    <meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
    <meta name="tags" content="<?php if($settings): ?><?php echo e($settings->meta_tags); ?><?php endif; ?>">
    <meta name="keywords" content="<?php if($settings): ?><?php echo e($settings->meta_keywords); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<div>
   <!-- Breadcrumb Navigation -->
    <div class="container mx-auto px-6 py-4">
        <nav class="text-gray-600 text-sm">
            <ul class="flex items-center space-x-2">
                <li><a href="/" class="text-blue-500 hover:underline">Home</a></li>
                <li><i class="fa fa-angle-right"></i></li>
                <li class="text-gray-500">All Categories</li>
            </ul>
        </nav>
    </div>
 <!-- Categories Section -->
    <section class="container mx-auto px-6 py-10">
        <h2 class="text-3xl font-bold text-center text-gray-800 mb-8">Categories</h2>
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white shadow-md rounded-lg p-4 flex flex-col items-center hover:shadow-lg transition">
                 <picture>
                        <source srcset="<?php echo e(asset('storage/' .$category->image)); ?>" type="image/webp" class="w-20 h-20 object-cover mb-4">
                        <img src="<?php echo e(asset('storage/' .$category->image)); ?>" alt="<?php echo e($category->name); ?>" class="w-20 h-20 object-cover mb-4">
                    </picture>
               
                <h3 class="text-lg font-semibold"><?php echo e($category->name); ?></h3>
                <a href="<?php echo e(route('user.products.by-category', $category->slug)); ?>" wire:navigate class="text-blue-500 mt-2">View Products</a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
           
        </div>
    </section>
</div>
<?php /**PATH /home/amersjqb/minmaxsolutionsllc.com/resources/views/livewire/user/category-page.blade.php ENDPATH**/ ?>