<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\Setting::find(1);
    $page_metas = \App\Models\PageMeta::find(1);
?>
    <!--[if BLOCK]><![endif]--><?php if($page_metas): ?><title><?php echo e($page_metas->contact_title); ?></title><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <meta name="title" content="<?php if($page_metas): ?><?php echo e($page_metas->contact_meta_title); ?><?php endif; ?>">
    <meta name="description" content="<?php if($page_metas): ?><?php echo e($page_metas->contact_meta_description); ?><?php endif; ?>">
    <meta name="tags" content="<?php if($page_metas): ?><?php echo e($page_metas->contact_meta_tags); ?><?php endif; ?>">
    <meta name="keywords" content="<?php if($page_metas): ?><?php echo e($page_metas->contact_meta_keywords); ?><?php endif; ?>">
    <!--[if BLOCK]><![endif]--><?php if($page_metas): ?><script><?php echo $page_metas->contact_page_schema; ?></script><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php $__env->stopSection(); ?>
<div class="min-h-screen bg-gradient-to-br from-g ray-50 to-gray-100">
    <!-- Breadcrumb Navigation -->
    <div class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-6 py-4">
            <nav class="text-gray-600 text-sm">
                <ul class="flex items-center space-x-2">
                    <li><a href="/" class="text-blue-500 hover:text-blue-600 hover:underline transition-colors duration-300">Home</a></li>
                    <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                    <li class="text-gray-500">Contact Us</li>
                </ul>
            </nav>
        </div>
    </div>

    <!-- Contact Section -->
    <section class="max-w-7xl mx-auto px-6 py-16">
        <!-- Header Section -->
        <div class="text-center mb-16">
            <div class="flex items-center justify-center mb-6">
                <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                    Get In <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-purple-600">Touch</span>
                </h2>
            </div>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                Have any questions? We'd love to hear from you! Our team is here to help.
            </p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Contact Information & Map -->
            <div class="space-y-8">
                <!-- Contact Cards -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Address Card -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 hover:shadow-xl transition-all duration-500 transform hover:-translate-y-1">
                        <div class="w-12 h-12 bg-gradient-to-br from-indigo-500 to-purple-500 rounded-xl flex items-center justify-center mb-4">
                            <i class="fas fa-map-marker-alt text-white text-lg"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Our Location</h3>
                        <p class="text-gray-600">1210 E Hufsmith Rd, Tomball, TX 77375, United States</p>
                    </div>

                    <!-- Email Card -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 hover:shadow-xl transition-all duration-500 transform hover:-translate-y-1">
                        <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-teal-500 rounded-xl flex items-center justify-center mb-4">
                            <i class="fas fa-envelope text-white text-lg"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Email Us</h3>
                        <a href="mailto:info@premierproductscous.com" class="text-indigo-600 hover:text-indigo-700 transition-colors font-medium">info@premierproductscous.com</a>
                    </div>

                    <!-- Phone Card -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 hover:shadow-xl transition-all duration-500 transform hover:-translate-y-1">
                        <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center mb-4">
                            <i class="fas fa-phone text-white text-lg"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Call Us</h3>
                        <a href="tel:5128906828" class="text-indigo-600 hover:text-indigo-700 transition-colors font-medium">512-890-6828</a>
                    </div>

                    <!-- Hours Card -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 hover:shadow-xl transition-all duration-500 transform hover:-translate-y-1">
                        <div class="w-12 h-12 bg-gradient-to-br from-amber-500 to-orange-500 rounded-xl flex items-center justify-center mb-4">
                            <i class="fas fa-clock text-white text-lg"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Business Hours</h3>
                        <p class="text-gray-600">Mon - Fri: 9:00 AM - 6:00 PM</p>
                    </div>
                </div>

                <!-- Google Map -->
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                    <div class="p-6 border-b border-gray-200">
                        <h3 class="text-xl font-semibold text-gray-900 flex items-center">
                            <i class="fas fa-map-marked-alt text-indigo-600 mr-3"></i>
                            Find Us Here
                        </h3>
                    </div>
                    <div class="h-80">
                        <iframe 
                            class="w-full h-full"
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3477.4606507480093!2d-95.61528152494613!3d30.091503575659497!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x8647317443f96ad5%3A0x42e3c4b95faff2da!2s1210%20E%20Hufsmith%20Rd%2C%20Tomball%2C%20TX%2077375%2C%20USA!5e0!3m2!1sen!2s!4v1707500000000"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
                        </iframe>
                    </div>
                </div>
            </div>

            <!-- Contact Form -->
            <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                <div class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white p-6">
                    <h3 class="text-2xl font-bold flex items-center">
                        <i class="fas fa-paper-plane mr-3"></i>
                        Send Us a Message
                    </h3>
                    <p class="text-indigo-100 mt-2">We'll get back to you within 24 hours</p>
                </div>
                
                <div class="p-8">
                    <form action="" method="POST" class="space-y-6">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Name Field -->
                        <div>
                            <label for="name" class="block text-gray-700 font-medium mb-2">Your Name</label>
                            <div class="relative">
                                <input type="text" 
                                       name="name" 
                                       placeholder="Enter your full name" 
                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php if($errors->has('name')): ?> border-red-500 <?php endif; ?>" 
                                       value="<?php echo e(old('name')); ?>">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <i class="fas fa-user text-gray-400"></i>
                                </div>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($errors->has('name')): ?>
                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($errors->first('name')); ?>

                                </p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Email Field -->
                        <div>
                            <label for="email" class="block text-gray-700 font-medium mb-2">Email Address</label>
                            <div class="relative">
                                <input type="email" 
                                       name="email" 
                                       placeholder="Enter your email address" 
                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php if($errors->has('email')): ?> border-red-500 <?php endif; ?>" 
                                       value="<?php echo e(old('email')); ?>">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <i class="fas fa-envelope text-gray-400"></i>
                                </div>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($errors->has('email')): ?>
                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($errors->first('email')); ?>

                                </p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Subject Field -->
                        <div>
                            <label for="subject" class="block text-gray-700 font-medium mb-2">Subject</label>
                            <div class="relative">
                                <input type="text" 
                                       name="subject" 
                                       placeholder="What is this regarding?" 
                                       class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 <?php if($errors->has('subject')): ?> border-red-500 <?php endif; ?>" 
                                       value="<?php echo e(old('subject')); ?>">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <i class="fas fa-tag text-gray-400"></i>
                                </div>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($errors->has('subject')): ?>
                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($errors->first('subject')); ?>

                                </p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Message Field -->
                        <div>
                            <label for="message" class="block text-gray-700 font-medium mb-2">Your Message</label>
                            <div class="relative">
                                <textarea name="message" 
                                          rows="5" 
                                          placeholder="Tell us how we can help you..." 
                                          class="w-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all duration-300 resize-none <?php if($errors->has('message')): ?> border-red-500 <?php endif; ?>"><?php echo e(old('message')); ?></textarea>
                                <div class="absolute top-4 right-3 flex items-center pointer-events-none">
                                    <i class="fas fa-edit text-gray-400"></i>
                                </div>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($errors->has('message')): ?>
                                <p class="text-red-600 text-sm mt-2 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($errors->first('message')); ?>

                                </p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Hidden reCAPTCHA Token -->
                        <input type="hidden" name="recaptcha_token" id="recaptcha_token">

                        <!-- Submit Button -->
                        <button type="submit" 
                                class="w-full bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-700 hover:to-purple-700 text-white font-semibold py-4 px-6 rounded-xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg flex items-center justify-center">
                            <i class="fas fa-paper-plane mr-2"></i>
                            Send Message
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Additional Contact Info -->
        <div class="mt-16 grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Support Info -->
            <div class="bg-white rounded-2xl shadow-lg p-6 text-center">
                <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-teal-500 rounded-2xl flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-headset text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Customer Support</h3>
                <p class="text-gray-600">Get help with your orders and account</p>
                <a href="mailto:support@premierproductscous.com" class="text-indigo-600 hover:text-indigo-700 font-medium mt-3 inline-block">support@premierproductscous.com</a>
            </div>

            <!-- Sales Info -->
            <div class="bg-white rounded-2xl shadow-lg p-6 text-center">
                <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-2xl flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-chart-line text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Sales Team</h3>
                <p class="text-gray-600">Inquiries about wholesale and partnerships</p>
                <a href="mailto:sales@premierproductscous.com" class="text-indigo-600 hover:text-indigo-700 font-medium mt-3 inline-block">sales@premierproductscous.com</a>
            </div>

            <!-- General Info -->
            <div class="bg-white rounded-2xl shadow-lg p-6 text-center">
                <div class="w-16 h-16 bg-gradient-to-br from-purple-500 to-pink-500 rounded-2xl flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-info-circle text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">General Inquiries</h3>
                <p class="text-gray-600">Questions about our products and services</p>
                <a href="mailto:info@premierproductscous.com" class="text-indigo-600 hover:text-indigo-700 font-medium mt-3 inline-block">info@premierproductscous.com</a>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /home/realzjjm/saas.dreamzplanet.com/resources/views/livewire/user/contact.blade.php ENDPATH**/ ?>