<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\Setting::find(1);
?>
    <!--[if BLOCK]><![endif]--><?php if($settings): ?><title><?php echo e($settings->site_title); ?></title><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
    <meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
    <meta name="tags" content="<?php if($settings): ?><?php echo e($settings->meta_tags); ?><?php endif; ?>">
    <meta name="keywords" content="<?php if($settings): ?><?php echo e($settings->meta_keywords); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100">
    <!-- Hero Banner -->
    <div class="relative w-full h-80 bg-gradient-to-r from-indigo-600 to-purple-600 overflow-hidden">
        <div class="absolute inset-0 bg-black/20"></div>
        <div class="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1486312338219-ce68d2c6f44d?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2072&q=80')] bg-cover bg-center opacity-10"></div>
        <div class="relative flex items-center justify-center h-full text-center">
            <div class="max-w-4xl px-6">
                <div class="flex items-center justify-center mb-6">
                    <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h1 class="text-5xl md:text-6xl font-bold text-white" style="font-family: 'Merriweather','serif';">Our Blog</h1>
                </div>
                <p class="text-xl text-white/90 max-w-2xl mx-auto">
                    Discover the latest insights, trends, and news in wholesale distribution
                </p>
            </div>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-6 py-16">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-12">
            <!-- Main Blog Content -->
            <div class="lg:col-span-3">
                <!-- Blog Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="group bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-500 overflow-hidden transform hover:-translate-y-2">
                            <!-- Blog Image -->
                            <div class="relative overflow-hidden">
                                <a href="">
                                    <img src="<?php echo e(asset('storage/' .$blog->image)); ?>" alt="<?php echo e($blog->title); ?>" 
                                         class="w-full h-48 object-cover transition-transform duration-700 group-hover:scale-110">
                                </a>
                                <!-- Category Badge -->
                                <div class="absolute top-4 left-4">
                                    <span class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white px-3 py-1 text-xs font-bold rounded-full shadow-lg">
                                        <?php echo e($blog->category->name ?? 'Uncategorized'); ?>

                                    </span>
                                </div>
                                <!-- Hover Overlay -->
                                <div class="absolute inset-0 bg-black opacity-0 group-hover:opacity-10 transition-opacity duration-300"></div>
                            </div>
                            
                            <!-- Blog Content -->
                            <div class="p-6">
                                <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-indigo-700 transition-colors duration-300 line-clamp-2">
                                    <?php echo e($blog->name); ?>

                                </h3>
                                <p class="text-gray-600 mb-4 line-clamp-3 leading-relaxed">
                                    <?php echo Str::limit(strip_tags($blog->content), 120); ?>

                                </p>
                                
                                <!-- Meta Information -->
                                <div class="flex items-center justify-between text-sm text-gray-500 mb-4">
                                    <div class="flex items-center">
                                        <i class="fas fa-calendar mr-2"></i>
                                        <span><?php echo e(\Carbon\Carbon::parse($blog->created_at)->diffForHumans()); ?></span>
                                    </div>
                                    <div class="flex items-center">
                                        <i class="fas fa-clock mr-2"></i>
                                        <span><?php echo e(ceil(str_word_count(strip_tags($blog->content)) / 200)); ?> min read</span>
                                    </div>
                                </div>
                                
                                <!-- Read More Button -->
                                <a href="<?php echo e(route('user.blog.detail',$blog->slug)); ?>" wire:navigate 
                                   class="inline-flex items-center text-indigo-600 hover:text-indigo-700 font-semibold transition-all duration-300 group/link">
                                    <span>Read More</span>
                                    <i class="fas fa-arrow-right ml-2 transform group-hover/link:translate-x-1 transition-transform duration-300"></i>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <!-- Empty State -->
                <!--[if BLOCK]><![endif]--><?php if($blogs->isEmpty()): ?>
                    <div class="text-center py-16">
                        <div class="w-24 h-24 bg-gray-200 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-newspaper text-gray-400 text-3xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4">No Blog Posts Yet</h3>
                        <p class="text-gray-600 max-w-md mx-auto">We're working on creating valuable content for you. Check back soon!</p>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            
            <!-- Sidebar -->
            <div class="lg:col-span-1">
                <div class="space-y-8">
                    <!-- Categories -->
                    <div class="bg-white rounded-2xl shadow-lg p-6">
                        <div class="flex items-center mb-6">
                            <div class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-500 rounded-lg flex items-center justify-center mr-3">
                                <i class="fas fa-tags text-white text-sm"></i>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900">Categories</h3>
                        </div>
                        <ul class="space-y-3">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="group">
                                    <a href="<?php echo e(route('user.products.by-category', $category->slug)); ?>" wire:navigate 
                                       class="flex items-center justify-between text-gray-700 hover:text-indigo-600 transition-colors duration-300 py-2 border-b border-gray-100 group-last:border-b-0">
                                        <span class="group-hover:translate-x-1 transition-transform duration-300"><?php echo e($category->name); ?></span>
                                        <i class="fas fa-chevron-right text-gray-400 text-xs group-hover:text-indigo-600 group-hover:translate-x-1 transition-all duration-300"></i>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </ul>
                    </div>

                    <!-- Recent Posts -->
                    <div class="bg-white rounded-2xl shadow-lg p-6">
                        <div class="flex items-center mb-6">
                            <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-teal-500 rounded-lg flex items-center justify-center mr-3">
                                <i class="fas fa-clock text-white text-sm"></i>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900">Recent Posts</h3>
                        </div>
                        <ul class="space-y-4">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="group">
                                    <a href="<?php echo e(route('user.blog.detail',$recent->slug)); ?>" wire:navigate 
                                       class="flex items-start space-x-3 text-gray-700 hover:text-indigo-600 transition-colors duration-300">
                                        <div class="flex-shrink-0 w-2 h-2 bg-indigo-300 rounded-full mt-2 group-hover:bg-indigo-600 transition-colors duration-300"></div>
                                        <span class="group-hover:translate-x-1 transition-transform duration-300 leading-relaxed"><?php echo e($recent->name); ?></span>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </ul>
                    </div>

                    <!-- Newsletter Subscription -->
                    <div class="bg-gradient-to-br from-indigo-600 to-purple-600 rounded-2xl p-6 text-white">
                        <div class="text-center mb-4">
                            <i class="fas fa-envelope-open-text text-3xl mb-3 opacity-90"></i>
                            <h3 class="text-xl font-bold mb-2">Stay Updated</h3>
                            <p class="text-indigo-100 text-sm">Get the latest blog posts delivered to your inbox</p>
                        </div>
                        <form class="space-y-3">
                            <input type="email" 
                                   placeholder="Enter your email" 
                                   class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-indigo-200 focus:outline-none focus:ring-2 focus:ring-white/50 focus:border-transparent">
                            <button type="submit" 
                                    class="w-full bg-white text-indigo-600 font-semibold py-3 rounded-lg hover:bg-gray-100 transition-colors duration-300">
                                Subscribe
                            </button>
                        </form>
                    </div>

                    <!-- Popular Tags -->
                    <div class="bg-white rounded-2xl shadow-lg p-6">
                        <div class="flex items-center mb-6">
                            <div class="w-8 h-8 bg-gradient-to-br from-amber-500 to-orange-500 rounded-lg flex items-center justify-center mr-3">
                                <i class="fas fa-hashtag text-white text-sm"></i>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900">Popular Tags</h3>
                        </div>
                        <div class="flex flex-wrap gap-2">
                            <span class="bg-gray-100 text-gray-700 px-3 py-1 rounded-full text-sm hover:bg-indigo-100 hover:text-indigo-700 transition-colors duration-300 cursor-pointer">Wholesale</span>
                            <span class="bg-gray-100 text-gray-700 px-3 py-1 rounded-full text-sm hover:bg-indigo-100 hover:text-indigo-700 transition-colors duration-300 cursor-pointer">Amazon</span>
                            <span class="bg-gray-100 text-gray-700 px-3 py-1 rounded-full text-sm hover:bg-indigo-100 hover:text-indigo-700 transition-colors duration-300 cursor-pointer">Distribution</span>
                            <span class="bg-gray-100 text-gray-700 px-3 py-1 rounded-full text-sm hover:bg-indigo-100 hover:text-indigo-700 transition-colors duration-300 cursor-pointer">Business</span>
                            <span class="bg-gray-100 text-gray-700 px-3 py-1 rounded-full text-sm hover:bg-indigo-100 hover:text-indigo-700 transition-colors duration-300 cursor-pointer">E-commerce</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/amersjqb/minmaxsolutionsllc.com/resources/views/livewire/user/blog-page.blade.php ENDPATH**/ ?>