<div>
     <?php $__env->slot('header', null, []); ?> Dashboard Overview <?php $__env->endSlot(); ?>
    
    <div class="space-y-6">
        <!-- Amazon-style Page Header -->
        <div class="bg-white rounded-lg border border-gray-200 p-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Dashboard Overview</h1>
                    <p class="text-gray-600 mt-1">Welcome to your admin console - <?php echo e(now()->format('F j, Y')); ?></p>
                </div>
                <div class="flex space-x-3">
                    <button 
                        wire:click="refreshData" 
                        class="px-4 py-2 bg-gray-100 text-gray-700 rounded-md hover:bg-gray-200 transition-colors flex items-center space-x-2 text-sm font-medium"
                        wire:loading.attr="disabled"
                        wire:target="refreshData"
                    >
                        <span wire:loading.remove wire:target="refreshData">
                            <i class="fas fa-refresh"></i>
                            <span>Refresh</span>
                        </span>
                        <span wire:loading wire:target="refreshData" class="flex items-center space-x-2">
                            <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-gray-700"></div>
                            <span>Refreshing...</span>
                        </span>
                    </button>
                    <a href="" class="px-4 py-2 bg-orange-500 text-white rounded-md hover:bg-orange-600 transition-colors flex items-center space-x-2 text-sm font-medium">
                        <i class="fas fa-plus"></i>
                        <span>New Lead</span>
                    </a>
                </div>
            </div>
        </div>

        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                <?php echo e(session('message')); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Amazon-style Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $stats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg border border-gray-200 p-6 hover:shadow-md transition-shadow">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-500 mb-1"><?php echo e($stat['title']); ?></p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($stat['value']); ?></p>
                            <div class="flex items-center mt-2">
                                <span class="text-sm font-medium text-<?php echo e($stat['change_type'] === 'increase' ? 'green' : 'red'); ?>-600 flex items-center">
                                    <!--[if BLOCK]><![endif]--><?php if($stat['change_type'] === 'increase'): ?>
                                        <i class="fas fa-arrow-up mr-1 text-xs"></i>
                                    <?php else: ?>
                                        <i class="fas fa-arrow-down mr-1 text-xs"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php echo e($stat['change']); ?>

                                </span>
                                <span class="text-xs text-gray-500 ml-2">from last month</span>
                            </div>
                        </div>
                        <div class="w-12 h-12 bg-<?php echo e($stat['color']); ?>-100 rounded-lg flex items-center justify-center ml-4">
                            <i class="fas fa-<?php echo e($stat['icon']); ?> text-<?php echo e($stat['color']); ?>-600 text-xl"></i>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <!-- Amazon-style Charts and Recent Activity -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Recent Leads -->
            <div class="bg-white rounded-lg border border-gray-200">
                <div class="flex justify-between items-center p-6 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Recent Leads</h3>
                    <a href="" class="text-sm text-orange-500 hover:text-orange-600 font-medium flex items-center space-x-1">
                        <span>View all</span>
                        <i class="fas fa-chevron-right text-xs"></i>
                    </a>
                </div>
                
                <div class="p-6">
                    <div class="space-y-4">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $recentLeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg border border-gray-100 hover:bg-gray-100 transition-colors">
                                <div class="flex items-center space-x-4">
                                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                        <i class="fas fa-user text-blue-600"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-gray-900"><?php echo e($lead['name']); ?></p>
                                        <p class="text-xs text-gray-500"><?php echo e($lead['email']); ?></p>
                                        <p class="text-xs text-gray-400 mt-1"><?php echo e($lead['company']); ?></p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm font-medium text-gray-900"><?php echo e($lead['source']); ?></p>
                                    <p class="text-xs text-gray-500"><?php echo e($lead['created_at']); ?></p>
                                    <p class="text-xs text-gray-400 mt-1"><?php echo e($lead['phone']); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <!--[if BLOCK]><![endif]--><?php if(empty($recentLeads)): ?>
                            <div class="text-center py-8 text-gray-500">
                                <i class="fas fa-inbox text-4xl mb-3 text-gray-300"></i>
                                <p class="text-gray-400">No leads yet</p>
                                <a href="" class="text-orange-500 hover:text-orange-600 text-sm mt-2 inline-block">
                                    Add your first lead
                                </a>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Latest Products -->
            <div class="bg-white rounded-lg border border-gray-200">
                <div class="flex justify-between items-center p-6 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Latest Products</h3>
                    <a href="<?php echo e(route('admin.products')); ?>" class="text-sm text-orange-500 hover:text-orange-600 font-medium flex items-center space-x-1">
                        <span>View all</span>
                        <i class="fas fa-chevron-right text-xs"></i>
                    </a>
                </div>
                
                <div class="p-6">
                    <div class="space-y-5">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg border border-gray-100 hover:bg-gray-100 transition-colors">
                                <div class="flex items-center space-x-4 flex-1">
                                    <!--[if BLOCK]><![endif]--><?php if($product['image']): ?>
                                        <img src="<?php echo e(asset('storage/' . $product['image'])); ?>" 
                                            alt="<?php echo e($product['name']); ?>" 
                                            class="w-12 h-12 rounded-lg object-cover border border-gray-200">
                                    <?php else: ?>
                                        <div class="w-12 h-12 bg-gray-100 rounded-lg flex items-center justify-center border border-gray-200">
                                            <i class="fas fa-cube text-gray-400 text-lg"></i>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <div class="flex-1">
                                        <p class="text-sm font-medium text-gray-900"><?php echo e($product['name']); ?></p>
                                        <p class="text-xs text-gray-500"><?php echo e($product['category']); ?></p>
                                        <!--[if BLOCK]><![endif]--><?php if($product['price']): ?>
                                            <p class="text-xs text-green-600 font-medium mt-1">$<?php echo e(number_format($product['price'], 2)); ?></p>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-xs text-gray-500"><?php echo e($product['created_at']); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <!--[if BLOCK]><![endif]--><?php if(empty($topProducts)): ?>
                            <div class="text-center py-8 text-gray-500">
                                <i class="fas fa-cube text-4xl mb-3 text-gray-300"></i>
                                <p class="text-gray-400">No products yet</p>
                                <a href="<?php echo e(route('admin.products')); ?>" class="text-orange-500 hover:text-orange-600 text-sm mt-2 inline-block">
                                    Add your first product
                                </a>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Stats Section -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Lead Source Distribution -->
            <div class="bg-white rounded-lg border border-gray-200">
                <div class="p-6 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Lead Sources</h3>
                </div>
                <div class="p-6">
                    <!--[if BLOCK]><![endif]--><?php if(!empty($leadStats['sources'])): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $leadStats['sources']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex justify-between items-center py-2">
                                <span class="text-sm text-gray-600 capitalize"><?php echo e($source ?: 'Unknown'); ?></span>
                                <span class="text-sm font-medium text-gray-900"><?php echo e($count); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <?php else: ?>
                        <p class="text-gray-500 text-center py-4">No lead sources data</p>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- Content Overview -->
            <div class="bg-white rounded-lg border border-gray-200">
                <div class="p-6 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Content Overview</h3>
                </div>
                <div class="p-6">
                    <?php
                        $contentStats = [
                            ['label' => 'Blog Posts', 'count' => \App\Models\Blog::count(), 'icon' => 'file-alt', 'color' => 'blue'],
                            ['label' => 'Banners', 'count' => \App\Models\Banner::count(), 'icon' => 'image', 'color' => 'green'],
                            ['label' => 'Brands', 'count' => \App\Models\Brand::count(), 'icon' => 'tag', 'color' => 'purple'],
                            ['label' => 'Pages', 'count' => \App\Models\Page::count(), 'icon' => 'file', 'color' => 'yellow'],
                        ];
                    ?>
                    
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $contentStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex justify-between items-center py-3 border-b border-gray-100 last:border-0">
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 bg-<?php echo e($stat['color']); ?>-100 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-<?php echo e($stat['icon']); ?> text-<?php echo e($stat['color']); ?>-600 text-sm"></i>
                                </div>
                                <span class="text-sm text-gray-600"><?php echo e($stat['label']); ?></span>
                            </div>
                            <span class="text-sm font-medium text-gray-900"><?php echo e($stat['count']); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- System Info -->
            <div class="bg-white rounded-lg border border-gray-200">
                <div class="p-6 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">System Info</h3>
                </div>
                <div class="p-6">
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Last Updated</span>
                            <span class="text-sm font-medium text-gray-900"><?php echo e($systemOverview['server_time']); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Total Users</span>
                            <span class="text-sm font-medium text-gray-900"><?php echo e(\App\Models\User::count()); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Latest User</span>
                            <span class="text-sm font-medium text-gray-900"><?php echo e($systemOverview['latest_user']->name ?? 'N/A'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Amazon-style Quick Actions -->
        <div class="bg-white rounded-lg border border-gray-200">
            <div class="p-6 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Quick Actions</h3>
            </div>
            
            <div class="p-6">
                <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
                    <a href="<?php echo e(route('admin.products')); ?>" wire:navigate class="p-4 bg-orange-50 border border-orange-200 rounded-lg hover:bg-orange-100 transition-colors flex flex-col items-center justify-center group">
                        <div class="w-10 h-10 bg-orange-500 rounded-lg flex items-center justify-center mb-3 group-hover:bg-orange-600 transition-colors">
                            <i class="fas fa-plus text-white"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-900 text-center">Add Product</span>
                    </a>
                    
                    <a href="" wire:navigate class="p-4 bg-gray-50 border border-gray-200 rounded-lg hover:bg-gray-100 transition-colors flex flex-col items-center justify-center group">
                        <div class="w-10 h-10 bg-gray-500 rounded-lg flex items-center justify-center mb-3 group-hover:bg-gray-600 transition-colors">
                            <i class="fas fa-users text-white"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-900 text-center">Manage Leads</span>
                    </a>
                    
                    <a href="<?php echo e(route('admin.categories')); ?>" wire:navigate class="p-4 bg-gray-50 border border-gray-200 rounded-lg hover:bg-gray-100 transition-colors flex flex-col items-center justify-center group">
                        <div class="w-10 h-10 bg-gray-500 rounded-lg flex items-center justify-center mb-3 group-hover:bg-gray-600 transition-colors">
                            <i class="fas fa-folder text-white"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-900 text-center">Categories</span>
                    </a>

                    <a href="<?php echo e(route('admin.blogs')); ?>" wire:navigate class="p-4 bg-blue-50 border border-blue-200 rounded-lg hover:bg-blue-100 transition-colors flex flex-col items-center justify-center group">
                        <div class="w-10 h-10 bg-blue-500 rounded-lg flex items-center justify-center mb-3 group-hover:bg-blue-600 transition-colors">
                            <i class="fas fa-edit text-white"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-900 text-center">Write Blog</span>
                    </a>

                    <a href="<?php echo e(route('admin.banners')); ?>" wire:navigate class="p-4 bg-green-50 border border-green-200 rounded-lg hover:bg-green-100 transition-colors flex flex-col items-center justify-center group">
                        <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center mb-3 group-hover:bg-green-600 transition-colors">
                            <i class="fas fa-image text-white"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-900 text-center">Banners</span>
                    </a>

                    <a href="<?php echo e(route('admin.settings')); ?>" wire:navigate class="p-4 bg-purple-50 border border-purple-200 rounded-lg hover:bg-purple-100 transition-colors flex flex-col items-center justify-center group">
                        <div class="w-10 h-10 bg-purple-500 rounded-lg flex items-center justify-center mb-3 group-hover:bg-purple-600 transition-colors">
                            <i class="fas fa-cog text-white"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-900 text-center">Settings</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/amersjqb/minmaxsolutionsllc.com/resources/views/livewire/admin/dashboard.blade.php ENDPATH**/ ?>