<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Wholesale Application Received</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #f8f9fa; padding: 20px; text-align: center; border-radius: 5px; }
        .content { background: white; padding: 20px; border-radius: 5px; margin-top: 20px; }
        .footer { margin-top: 20px; padding: 20px; background: #f8f9fa; text-align: center; border-radius: 5px; font-size: 12px; color: #666; }
        .thank-you { font-size: 18px; font-weight: bold; color: #2d3748; margin-bottom: 15px; }
        .next-steps { background: #e6fffa; padding: 15px; border-radius: 5px; margin: 20px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Wholesale Application Received</h1>
            <p>Thank you for your interest in becoming a wholesale partner!</p>
        </div>
        
        <div class="content">
            <div class="thank-you">
                Dear <?php echo e($lead->firstname); ?> <?php echo e($lead->lastname); ?>,
            </div>
            
            <p>We have successfully received your wholesale application and are currently reviewing it. Our team will carefully evaluate your submission and get back to you within 2-3 business days.</p>
            
            <div class="next-steps">
                <h3>What happens next?</h3>
                <ul>
                    <li>Our team will review your application</li>
                    <li>We may contact you for additional information</li>
                    <li>You'll receive a decision within 2-3 business days</li>
                    <li>Upon approval, you'll receive wholesale pricing and account access</li>
                </ul>
            </div>
            
            <p><strong>Application Reference:</strong> #<?php echo e($lead->id); ?></p>
            <p><strong>Submitted:</strong> <?php echo e($lead->created_at->format('F j, Y \a\t g:i A')); ?></p>
            
            <p>If you have any questions in the meantime, please don't hesitate to contact our wholesale department.</p>
            
            <p>Best regards,<br>
            The <?php echo e($companyName); ?> Team</p>
        </div>
        
        <div class="footer">
            <p>This is an automated confirmation email. Please do not reply to this message.</p>
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e($companyName); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/amersjqb/minmaxsolutionsllc.com/resources/views/emails/customer-confirmation.blade.php ENDPATH**/ ?>