<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\Setting::find(1);
    $page_metas = \App\Models\PageMeta::find(1);
?>
    <!--[if BLOCK]><![endif]--><?php if($page_metas): ?><title><?php echo e($page_metas->product_title); ?></title><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <meta name="title" content="<?php if($page_metas): ?><?php echo e($page_metas->product_meta_title); ?><?php endif; ?>">
    <meta name="description" content="<?php if($page_metas): ?><?php echo e($page_metas->product_meta_description); ?><?php endif; ?>">
    <meta name="tags" content="<?php if($page_metas): ?><?php echo e($page_metas->product_meta_tags); ?><?php endif; ?>">
    <meta name="keywords" content="<?php if($page_metas): ?><?php echo e($page_metas->product_meta_keywords); ?><?php endif; ?>">
    <!--[if BLOCK]><![endif]--><?php if($page_metas): ?><script><?php echo $page_metas->product_page_schema; ?></script><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php $__env->stopSection(); ?>
<div>
      <div class="container mx-auto px-6 py-4">
        <nav class="text-gray-600 text-sm">
            <ul class="flex items-center space-x-2">
                <li><a href="/" class="text-blue-500 hover:underline">Home</a></li>
                <li><i class="fa fa-angle-right"></i></li>
                <li class="text-gray-500">Products</li>
            </ul>
        </nav>
    </div>
 

   <section class="py-20 relative overflow-hidden">
    <style>
        @keyframes fadeInUp {
            0% { 
                opacity: 0; 
                transform: translateY(30px); 
            }
            100% { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        @keyframes pulse {
            0%, 100% { 
                transform: scale(1); 
            }
            50% { 
                transform: scale(1.05); 
            }
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 0.8s ease-out forwards;
            opacity: 0;
        }
        
        .animate-pulse-slow {
            animation: pulse 4s ease-in-out infinite;
        }
        
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        .delay-400 { animation-delay: 0.4s; }
        
        .gradient-border {
            position: relative;
            background: linear-gradient(white, white) padding-box,
                        linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(168, 85, 247, 0.1)) border-box;
            border: 1px solid transparent;
        }
        
        .card-hover {
            transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        .card-hover:hover {
            transform: translateY(-10px);
        }
        
        .image-placeholder {
            background: linear-gradient(45deg, #f3f4f6, #e5e7eb);
        }
    </style>
        <!-- Background decorative elements -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-blue-900/5 rounded-full"></div>
            <div class="absolute -bottom-32 -left-32 w-80 h-80 bg-yellow-500/5 rounded-full"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl h-64 bg-gradient-to-r from-blue-900/5 to-yellow-500/5 blur-3xl rounded-full"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <!-- Section Header -->
           
            <div class="text-center mb-16">
                <div class="inline-flex items-center justify-center mb-6 animate-slide-in-left">
                    <div class="w-3 h-12 bg-gradient-to-b from-yellow-400 to-yellow-500 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather', serif;">
                        Our <span class="text-gradient">Wholesale</span> Products
                    </h2>
                </div>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto animate-fade-in-up">
                    Discover our curated selection of high-demand Amazon products available at exclusive wholesale prices
                </p>
            </div>

            <!-- Products Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
                
                <!-- Product Card 1 -->
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="group relative animate-fadeInUp delay-100">
                    <div class="absolute -inset-2 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-3xl blur opacity-20 group-hover:opacity-40 transition duration-1000 group-hover:duration-200"></div>
                    <div class="relative gradient-border rounded-3xl overflow-hidden shadow-lg card-hover bg-white">
                        <!-- Product Image -->
                        <div class="relative h-56 overflow-hidden">
                            <div class="w-full h-full image-placeholder flex items-center justify-center">
                                <img src="<?php echo e(asset('storage/' . $product->image)); ?>" alt="">
                            </div>
                            <!-- Hover Overlay -->
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end p-4">
                                <div class="transform translate-y-4 group-hover:translate-y-0 transition-transform duration-300">
                                    <span class="inline-block bg-white/20 backdrop-blur-sm text-white text-sm px-3 py-1 rounded-full"><?php echo e($product->category->name); ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Product Details -->
                        <div class="p-6">
                            <div class="flex items-start justify-between mb-3">
                                <h3 class="text-sm font-bold text-gray-800 flex-1"><?php echo e($product->name); ?></h3>
                                <div class="flex items-center ml-2">
                                    <i class="fas fa-star text-yellow-400 text-sm"></i>
                                    <span class="text-gray-600 text-sm ml-1">4.8</span>
                                </div>
                            </div>
                            
                            
                            
                            <a href="<?php echo e(route('user.apply-wholesale')); ?>" wire:navigate 
                               class="w-full inline-flex items-center justify-center bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-700 hover:to-purple-700 text-white font-semibold py-3 px-4 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 group">
                                <span>Apply for Wholesale</span>
                                <svg class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            
            <!-- Bottom CTA -->
            <div class="mt-16 text-center animate-fadeInUp delay-400">
                <div class="inline-flex flex-col sm:flex-row items-center justify-center space-y-4 sm:space-y-0 sm:space-x-6 bg-white/80 backdrop-blur-sm rounded-2xl p-6 shadow-lg border border-gray-200 max-w-2xl mx-auto">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-br from-indigo-500 to-purple-500 flex items-center justify-center shadow-md">
                            <i class="fas fa-boxes text-white"></i>
                        </div>
                        <div class="text-left">
                            <p class="font-bold text-gray-800">Need bulk pricing for your business?</p>
                            <p class="text-gray-600 text-sm">Contact us for custom wholesale solutions</p>
                        </div>
                    </div>
                    <a href="#contact" class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-semibold rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 hover:scale-105">
                        Contact Sales
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /home/realzjjm/saas.dreamzplanet.com/resources/views/livewire/user/product-page.blade.php ENDPATH**/ ?>