<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\Setting::find(1);
    $page_metas = \App\Models\PageMeta::find(1);
?>
    <!--[if BLOCK]><![endif]--><?php if($page_metas): ?><title><?php echo e($page_metas->about_title); ?></title><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <meta name="title" content="<?php if($page_metas): ?><?php echo e($page_metas->about_meta_title); ?><?php endif; ?>">
    <meta name="description" content="<?php if($page_metas): ?><?php echo e($page_metas->about_meta_description); ?><?php endif; ?>">
    <meta name="tags" content="<?php if($page_metas): ?><?php echo e($page_metas->about_meta_tags); ?><?php endif; ?>">
    <meta name="keywords" content="<?php if($page_metas): ?><?php echo e($page_metas->about_meta_keywords); ?><?php endif; ?>">
    <!--[if BLOCK]><![endif]--><?php if($page_metas): ?><script><?php echo $page_metas->about_page_schema; ?></script><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php $__env->stopSection(); ?>
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100">
    <!-- Breadcrumb Navigation -->
    <div class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-6 py-4">
            <nav class="text-gray-600 text-sm">
                <ul class="flex items-center space-x-2">
                    <li><a href="/" class="text-blue-500 hover:text-blue-600 hover:underline transition-colors duration-300">Home</a></li>
                    <li><i class="fas fa-chevron-right text-gray-400 text-xs"></i></li>
                    <li class="text-gray-500">About Us</li>
                </ul>
            </nav>
        </div>
    </div>

    <!-- About Us Section -->
    <section class="max-w-7xl mx-auto px-6 py-16">
        <!-- Header Section -->
        <div class="text-center mb-16">
            <div class="flex items-center justify-center mb-6">
                <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                <h2 class="text-4xl md:text-5xl font-bold text-gray-900" style="font-family: 'Merriweather','serif';">
                    About <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-purple-600">Our Company</span>
                </h2>
            </div>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Learn about our journey, mission, and commitment to being your trusted wholesale partner
            </p>
        </div>

        <!-- Main Content -->
        <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
            <!-- Hero Image -->
            <div class="relative h-80 md:h-96 overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-r from-indigo-600 to-purple-600 flex items-center justify-center">
                    <div class="text-center text-white p-8">
                        <i class="fas fa-building text-6xl mb-4 opacity-20"></i>
                        <p class="text-lg opacity-75">About Us Image</p>
                    </div>
                </div>
                <div class="absolute inset-0 bg-black opacity-20"></div>
                <div class="absolute bottom-6 left-6 bg-white/90 backdrop-blur-sm rounded-xl p-4 max-w-md">
                    <h1 class="text-2xl md:text-3xl font-bold text-gray-900">Top Amazon Wholesale Supplier for Amazon Sellers</h1>
                </div>
            </div>

            <!-- Content Section -->
            <div class="p-8 md:p-12">
                <!-- Introduction -->
                <div class="prose prose-lg max-w-none">
                    <p class="text-gray-700 text-lg leading-relaxed mb-6">
                        <a href="https://premierproductscous.com/" class="text-indigo-600 hover:text-indigo-700 font-semibold transition-colors">Premier Products CO. U.S.</a> has started as a small sales venture and is growing into a global <a href="https://premierproductscous.com/" class="text-indigo-600 hover:text-indigo-700 font-semibold transition-colors">wholesale distributor</a>. We offer <a href="https://premierproductscous.com/" class="text-indigo-600 hover:text-indigo-700 font-semibold transition-colors">wholesale suppliers</a> and distribution services for general merchandise, <a href="https://premierproductscous.com/about-us" class="text-indigo-600 hover:text-indigo-700 font-semibold transition-colors">household goods wholesaler</a>, <a href="https://premierproductscous.com/grocery-and-gourmet-food-wholesale" class="text-indigo-600 hover:text-indigo-700 font-semibold transition-colors">wholesale grocery distributors</a>, <a href="https://premierproductscous.com/beauty-personal-care-wholesale" class="text-indigo-600 hover:text-indigo-700 font-semibold transition-colors">beauty supply wholesale</a>, Pet supplies, Office products, toys, and more.
                    </p>

                    <p class="text-gray-700 text-lg leading-relaxed mb-6">
                        Becoming one of the key sources for groceries, and Pet supplies, Office products, and toys for the Los Angeles retail market. Our primary focus is the best quality and results that customers can find on the market. When you work with us, you will have no problem getting the products that you want.
                    </p>
                </div>

                <!-- Mission & Vision Section -->
                <div class="mt-12 grid grid-cols-1 lg:grid-cols-2 gap-8">
                    <!-- Mission -->
                    <div class="bg-gradient-to-br from-indigo-50 to-purple-50 rounded-2xl p-8 border-l-4 border-indigo-500">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 bg-indigo-500 rounded-xl flex items-center justify-center mr-4">
                                <i class="fas fa-bullseye text-white text-xl"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Our Mission</h2>
                        </div>
                        <p class="text-gray-700 leading-relaxed">
                            We are holding and creating more direct relationships with top-tier brands, manufacturers, and large importers. This allows us to provide competitive pricing on the products we offer.
                        </p>
                    </div>

                    <!-- Vision -->
                    <div class="bg-gradient-to-br from-purple-50 to-pink-50 rounded-2xl p-8 border-l-4 border-purple-500">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 bg-purple-500 rounded-xl flex items-center justify-center mr-4">
                                <i class="fas fa-eye text-white text-xl"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Our Vision</h2>
                        </div>
                        <p class="text-gray-700 leading-relaxed">
                            To become the most trusted and reliable wholesale distributor, providing unparalleled value and service to our partners while maintaining the highest standards of quality and integrity.
                        </p>
                    </div>
                </div>

                <!-- Additional Content -->
                <div class="mt-12">
                    <div class="prose prose-lg max-w-none">
                        <p class="text-gray-700 text-lg leading-relaxed mb-6">
                            Our buying power and network of suppliers gives you a huge assortment of products at low prices. With over 800 SKUs, whether it's brand name merchandise or dollar store items, our prices are unbeatable. New items are added daily, along with discounts and markdowns for bigger savings.
                        </p>

                        <p class="text-gray-700 text-lg leading-relaxed mb-6">
                            On top of great savings we offer our customers closeout daily deals, below wholesale prices.
                        </p>
                    </div>
                </div>

                <!-- Stats Section -->
                <div class="mt-16 grid grid-cols-2 md:grid-cols-4 gap-6">
                    <div class="text-center bg-white rounded-2xl p-6 shadow-lg border border-gray-100">
                        <div class="text-3xl font-bold text-indigo-600 mb-2">800+</div>
                        <div class="text-gray-600 font-medium">SKUs Available</div>
                    </div>
                    <div class="text-center bg-white rounded-2xl p-6 shadow-lg border border-gray-100">
                        <div class="text-3xl font-bold text-indigo-600 mb-2">100+</div>
                        <div class="text-gray-600 font-medium">Brand Partners</div>
                    </div>
                    <div class="text-center bg-white rounded-2xl p-6 shadow-lg border border-gray-100">
                        <div class="text-3xl font-bold text-indigo-600 mb-2">24/7</div>
                        <div class="text-gray-600 font-medium">Customer Support</div>
                    </div>
                    <div class="text-center bg-white rounded-2xl p-6 shadow-lg border border-gray-100">
                        <div class="text-3xl font-bold text-indigo-600 mb-2">5+</div>
                        <div class="text-gray-600 font-medium">Years Experience</div>
                    </div>
                </div>

                <!-- Value Proposition -->
                <div class="mt-16 bg-gradient-to-r from-indigo-600 to-purple-600 rounded-2xl p-8 text-white">
                    <h3 class="text-2xl font-bold mb-4 text-center">Why Choose Premier Products CO. U.S.?</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-8">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-white/20 flex items-center justify-center">
                                    <i class="fas fa-check text-white text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-indigo-100">Competitive pricing with unbeatable wholesale rates</p>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-white/20 flex items-center justify-center">
                                    <i class="fas fa-check text-white text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-indigo-100">Extensive product range across multiple categories</p>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-white/20 flex items-center justify-center">
                                    <i class="fas fa-check text-white text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-indigo-100">Direct relationships with top-tier brands and manufacturers</p>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <div class="w-6 h-6 rounded-full bg-white/20 flex items-center justify-center">
                                    <i class="fas fa-check text-white text-xs"></i>
                                </div>
                            </div>
                            <p class="ml-3 text-indigo-100">Daily deals and closeout specials for maximum savings</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="mt-16 text-center">
            <div class="bg-white rounded-2xl shadow-lg p-8 max-w-4xl mx-auto">
                <h3 class="text-2xl font-bold text-gray-900 mb-4">Ready to Partner With Us?</h3>
                <p class="text-gray-600 mb-6 max-w-2xl mx-auto">
                    Join thousands of satisfied Amazon sellers who trust Premier Products CO. U.S. for their wholesale needs.
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="#" class="bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-700 hover:to-purple-700 text-white font-semibold py-3 px-8 rounded-xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg">
                        Apply for Wholesale Account
                    </a>
                    <a href="#" class="bg-white border border-indigo-600 text-indigo-600 hover:bg-indigo-50 font-semibold py-3 px-8 rounded-xl transition-all duration-300">
                        Contact Our Team
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /home/realzjjm/saas.dreamzplanet.com/resources/views/livewire/user/about.blade.php ENDPATH**/ ?>