<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>New Wholesale Application</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #f8f9fa; padding: 20px; text-align: center; border-radius: 5px; }
        .content { background: white; padding: 20px; border-radius: 5px; margin-top: 20px; }
        .field { margin-bottom: 10px; }
        .field-label { font-weight: bold; color: #555; }
        .footer { margin-top: 20px; padding: 20px; background: #f8f9fa; text-align: center; border-radius: 5px; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Wholesale Application</h1>
            <p>You have received a new wholesale application from your website.</p>
        </div>
        
        <div class="content">
            <h2>Applicant Information</h2>
            
            <div class="field">
                <span class="field-label">Name:</span>
                <?php echo e($lead->firstname); ?> <?php echo e($lead->lastname); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Company:</span>
                <?php echo e($lead->companyname ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Email:</span>
                <?php echo e($lead->email ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Phone:</span>
                <?php echo e($lead->phone ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Address:</span>
                <?php echo e($lead->address_primary ?? 'N/A'); ?>

                <?php if($lead->address_secondary): ?>
                    , <?php echo e($lead->address_secondary); ?>

                <?php endif; ?>
            </div>
            
            <div class="field">
                <span class="field-label">Location:</span>
                <?php echo e($lead->city ?? 'N/A'); ?>, <?php echo e($lead->state ?? 'N/A'); ?>, <?php echo e($lead->country ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Seller Permit:</span>
                <?php echo e($lead->seller_permit ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Business Duration:</span>
                <?php echo e($lead->period ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Sales Location:</span>
                <?php echo e($lead->location ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">How they heard about us:</span>
                <?php echo e($lead->reference ?? 'N/A'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Source:</span>
                <?php echo e($lead->source ?? 'Website'); ?>

            </div>
            
            <div class="field">
                <span class="field-label">Submitted:</span>
                <?php echo e($lead->created_at->format('F j, Y \a\t g:i A')); ?>

            </div>
            
            <?php if($lead->permit_doc): ?>
            <div class="field">
                <span class="field-label">Permit Document:</span>
                <a href="<?php echo e(asset('storage/' . $lead->permit_doc)); ?>" target="_blank">View Document</a>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="footer">
            <p>This email was sent automatically from your website. Please do not reply to this email.</p>
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name', 'Your Company')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/amersjqb/minmaxsolutionsllc.com/resources/views/emails/admin-wholesale-notification.blade.php ENDPATH**/ ?>