<?php $__env->startSection('meta-content'); ?>
<?php
    $settings = \App\Models\Setting::find(1);
?>
    <!--[if BLOCK]><![endif]--><?php if($settings): ?><title><?php echo e($settings->site_title); ?></title><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <meta name="title" content="<?php if($blog): ?><?php echo e($blog->meta_title); ?><?php endif; ?>">
    <meta name="description" content="<?php if($blog): ?><?php echo e($blog->meta_description); ?><?php endif; ?>">
    <meta name="tags" content="<?php if($blog): ?><?php echo e($blog->meta_tags); ?><?php endif; ?>">
    <meta name="keywords" content="<?php if($blog): ?><?php echo e($blog->meta_keywords); ?><?php endif; ?>">
    <!--[if BLOCK]><![endif]--><?php if($blog): ?><script><?php echo $blog->page_schema; ?></script><?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php $__env->stopSection(); ?>
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100">
    
<style>
.prose {
    line-height: 1.75;
}

.prose h1, .prose h2, .prose h3, .prose h4 {
    margin-top: 2em;
    margin-bottom: 1em;
    font-weight: 700;
}

.prose h2 {
    font-size: 1.5em;
    border-bottom: 2px solid #4f46e5;
    padding-bottom: 0.5em;
}

.prose p {
    margin-bottom: 1.5em;
}

.prose img {
    border-radius: 0.75rem;
    margin: 2em 0;
    box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
}

.prose blockquote {
    border-left-width: 4px;
    padding: 1.5em 2em;
    margin: 2em 0;
    border-radius: 0.75rem;
    background: linear-gradient(135deg, #f0f4ff 0%, #f8faff 100%);
}

.prose ul, .prose ol {
    margin: 1.5em 0;
    padding-left: 1.5em;
}

.prose li {
    margin: 0.5em 0;
}

.prose table {
    width: 100%;
    border-collapse: collapse;
    margin: 2em 0;
    border-radius: 0.75rem;
    overflow: hidden;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.prose th, .prose td {
    border: 1px solid #e5e7eb;
    padding: 1em;
    text-align: left;
}

.prose th {
    background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
    color: white;
    font-weight: 600;
}

.prose code {
    background: #f1f5f9;
    padding: 0.25em 0.5em;
    border-radius: 0.375rem;
    font-size: 0.875em;
    color: #475569;
}

.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
</style>
    <div class="max-w-7xl mx-auto px-4 py-8">
        <!-- Enhanced Breadcrumb -->
        <nav class="flex mb-8" aria-label="Breadcrumb">
            <ol class="flex items-center space-x-3 text-sm">
                <li>
                    <a href="/" class="text-blue-500 hover:text-blue-600 transition-colors duration-300 font-medium">Home</a>
                </li>
                <li class="flex items-center">
                    <i class="fas fa-chevron-right text-gray-400 text-xs"></i>
                    <a href="/blog" class="text-blue-500 hover:text-blue-600 transition-colors duration-300 font-medium ml-3">Blog</a>
                </li>
                <li class="flex items-center">
                    <i class="fas fa-chevron-right text-gray-400 text-xs"></i>
                    <span class="text-gray-900 font-semibold ml-3"><?php echo e($blog->category->name ?? 'Uncategorized'); ?></span>
                </li>
            </ol>
        </nav>

        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Main Content (70%) -->
            <div class="lg:w-8/12">
                <!-- Article Header -->
                <section class="mb-8">
                    <div class="flex items-center mb-6">
                        <div class="w-3 h-12 bg-gradient-to-b from-indigo-600 to-purple-600 rounded-full mr-4 transform rotate-12 shadow-md"></div>
                        <h1 class="text-4xl lg:text-5xl font-bold text-gray-900 leading-tight" style="font-family: 'Merriweather','serif';">
                            <?php echo e($blog->name); ?>

                        </h1>
                    </div>
                    
                    <!-- Meta Information -->
                    <div class="flex flex-wrap items-center gap-6 mb-8 border-b border-gray-200 pb-6">
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-gradient-to-br from-indigo-500 to-purple-500 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-user text-white text-lg"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-gray-900"><?php echo e($blog->author ?? 'Admin'); ?></p>
                                <p class="text-sm text-gray-500"><?php echo e($blog->created_at->format('F j, Y')); ?></p>
                            </div>
                        </div>
                        
                        
                       
                    </div>
                </section>

                <!-- Featured Image -->
                <!--[if BLOCK]><![endif]--><?php if($blog->image): ?>
                <div class="relative rounded-2xl overflow-hidden shadow-2xl mb-8">
                    <img src="<?php echo e(asset('storage/' .$blog->image)); ?>" 
                         alt="<?php echo e($blog->name); ?>" 
                         class="w-full h-96 object-cover">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/40 to-transparent"></div>
                    
                    <!-- Category Badge -->
                    <div class="absolute top-6 left-6">
                        <span class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white px-4 py-2 text-sm font-bold rounded-full inline-flex items-center shadow-lg">
                            <i class="fas fa-tag mr-2"></i>
                            <?php echo e($blog->category->name ?? 'Uncategorized'); ?>

                        </span>
                    </div>
                </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!-- Article Content -->
                <article class="bg-white rounded-2xl shadow-lg overflow-hidden mb-8">
                    <div class="p-8">
                        <!-- Article Body -->
                        <div class="prose prose-lg max-w-none 
                                    prose-headings:text-gray-900 prose-headings:font-bold
                                    prose-p:text-gray-700 prose-p:leading-relaxed
                                    prose-a:text-indigo-600 prose-a:no-underline hover:prose-a:underline
                                    prose-blockquote:border-l-4 prose-blockquote:border-indigo-600 prose-blockquote:bg-indigo-50 prose-blockquote:italic prose-blockquote:pl-6
                                    prose-strong:text-gray-900
                                    prose-ul:text-gray-700 prose-ol:text-gray-700
                                    prose-img:rounded-xl prose-img:shadow-md
                                    prose-table:border-collapse prose-table:border prose-table:border-gray-300
                                    prose-th:bg-gray-100 prose-th:text-gray-900 prose-th:p-4
                                    prose-td:p-4 prose-td:border prose-td:border-gray-300">
                            <?php echo $blog->description; ?>

                        </div>

                        <!-- Tags -->
                        <!--[if BLOCK]><![endif]--><?php if($blog->meta_tags): ?>
                        <div class="mt-8 pt-6 border-t border-gray-200">
                            <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                <i class="fas fa-tags text-indigo-600 mr-2"></i>
                                Article Tags
                            </h4>
                            <div class="flex flex-wrap gap-2">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = explode(',', $blog->meta_tags); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="bg-gray-100 text-gray-700 px-4 py-2 rounded-full text-sm hover:bg-indigo-100 hover:text-indigo-700 transition-colors duration-300 cursor-pointer font-medium">
                                    #<?php echo e(trim($tag)); ?>

                                </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Share Buttons -->
                        <div class="mt-8 pt-6 border-t border-gray-200">
                            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                                <span class="text-gray-700 font-semibold text-lg">Share this article</span>
                                <div class="flex space-x-3">
                                    <a href="#" class="w-12 h-12 bg-blue-600 text-white rounded-xl flex items-center justify-center hover:bg-blue-700 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg">
                                        <i class="fab fa-facebook-f text-lg"></i>
                                    </a>
                                    <a href="#" class="w-12 h-12 bg-blue-400 text-white rounded-xl flex items-center justify-center hover:bg-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg">
                                        <i class="fab fa-twitter text-lg"></i>
                                    </a>
                                    <a href="#" class="w-12 h-12 bg-blue-700 text-white rounded-xl flex items-center justify-center hover:bg-blue-800 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg">
                                        <i class="fab fa-linkedin-in text-lg"></i>
                                    </a>
                                    <button x-data="{ copied: false }" 
                                            @click="navigator.clipboard.writeText(window.location.href); copied = true; setTimeout(() => copied = false, 2000)"
                                            class="w-12 h-12 bg-gray-600 text-white rounded-xl flex items-center justify-center hover:bg-gray-700 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-lg relative">
                                        <i x-show="!copied" class="fas fa-link text-lg"></i>
                                        <i x-show="copied" class="fas fa-check text-lg"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </article>

                
            </div>

            <!-- Sidebar (30%) -->
            <div class="lg:w-4/12">
                <div class="space-y-8 sticky top-8">
                    <!-- Newsletter -->
                    <div class="bg-gradient-to-br from-indigo-600 to-purple-600 rounded-2xl p-6 text-white">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-envelope-open-text text-white text-2xl"></i>
                            </div>
                            <h3 class="text-xl font-bold mb-2">Stay Updated</h3>
                            <p class="text-indigo-100 text-sm mb-4">
                                Get the latest articles and insights delivered to your inbox.
                            </p>
                            <div class="space-y-3">
                                <input type="email" 
                                       placeholder="Enter your email" 
                                       class="w-full px-4 py-3 rounded-xl bg-white/10 border border-white/20 text-white placeholder-indigo-200 focus:outline-none focus:ring-2 focus:ring-white/50 focus:border-transparent text-sm">
                                <button class="w-full bg-white text-indigo-600 font-bold py-3 rounded-xl hover:bg-gray-100 transition-colors duration-300 text-sm">
                                    Subscribe Now
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Trending Posts -->
                    <div class="bg-white rounded-2xl shadow-lg p-6">
                        <div class="flex items-center mb-6">
                            <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-orange-500 rounded-xl flex items-center justify-center mr-3">
                                <i class="fas fa-fire text-white text-lg"></i>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900">Trending Now</h3>
                        </div>
                        <div class="space-y-4">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <article class="flex space-x-4 group cursor-pointer">
                               <a href="<?php echo e(route('user.blog.detail',$row->slug)); ?>" wire:navigate class="flex items-center space-x-4">
                                 <div class="flex-shrink-0 w-16 h-16 bg-gray-200 rounded-xl overflow-hidden">
                                    <div class="w-full h-full bg-gradient-to-br from-indigo-400 to-purple-500 flex items-center justify-center">
                                        <i class="fas fa-newspaper text-white text-sm"></i>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h4 class="text-sm font-semibold text-gray-900 group-hover:text-indigo-600 transition-colors duration-300 line-clamp-2 mb-1">
                                        <?php echo e($row->title); ?>

                                    </h4>
                                    <div class="flex items-center text-xs text-gray-500">
                                        <span><?php echo e($row->created_at->diffForHumans()); ?></span>
                                    </div>
                                </div>
                               </a>
                            </article>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <!-- Categories -->
                    <div class="bg-white rounded-2xl shadow-lg p-6">
                        <div class="flex items-center mb-6">
                            <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-teal-500 rounded-xl flex items-center justify-center mr-3">
                                <i class="fas fa-folder text-white text-lg"></i>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900">Categories</h3>
                        </div>
                        <div class="space-y-3">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('user.products.by-category',$category->slug)); ?>" class="flex items-center justify-between py-3 px-4 rounded-xl hover:bg-indigo-50 group transition-all duration-300">
                                <span class="text-gray-700 font-medium group-hover:text-indigo-600"><?php echo e($category->name); ?></span>
                                
                            </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    

                    
                </div>
            </div>
        </div>

       
    </div>
</div>

<?php /**PATH /home/amersjqb/minmaxsolutionsllc.com/resources/views/livewire/user/blog-detail.blade.php ENDPATH**/ ?>